#ifndef __SIGMA86_2D_H
#define __SIGMA86_2D_H


/**
 *   Init Sigma86 GFX engine
 */
int Sigma86_Init(void);

/**
 *  Init Sigma86 GFX engine
 */

int GFX_Init(void);

/**
 *   Release Sigma86 GFX engine
 */
int Sigma86_Done(void);



/**
 *   Fill an rectangle whose region is defined by (x,y,x+w-1,y+h-1) with color color.
 *   The color is 32bit (ARGB). It will be dithering into the current OSD format.
 */
int sigma86_gui2d_fill(int x, int y, int w, int h, int color);


/**
 *   Copy data from (sx,sy) to (dx,dy)   
 *
 */

int sigma86_gui2d_copyarea(int sx,int sy, int w, int h, int dx, int dy);



/**
 *   Draw an (RGB) 24 bit images into the OSD. It will scale the image is sw != dw or
 *   sh != dh.
 */
int sigma86_gui2d_DrawImage24(int sx,int sy, int sw,int sh,int dx,int dy,int dw,int dh, char *bitmap);


#endif
