#include <stdio.h>
#include <stdlib.h>
#include "devmalloc.h"

#define IMAGE_SLACK_NUMBER 1
#define IMAGE_BUF_SIZE 720*480*3
#define IMAGE_MAX_SIZE 1

#if 1
static char *slack_buf;
#else
static char slack_buf[IMAGE_SLACK_NUMBER][IMAGE_BUF_SIZE];
#endif
char *st_buf[IMAGE_MAX_SIZE];
int buf_pool[IMAGE_MAX_SIZE]={0};
//int buf_pool[IMAGE_MAX_SIZE]={0,0,0,0};


int STATIC_malloc_init()
{
#if 1
	if (slack_buf == NULL)
		slack_buf = malloc(sizeof(char) * (720 * 480 * 3));
	st_buf[0] = slack_buf;
#else
	int i;
	for(i=0;i<IMAGE_SLACK_NUMBER;i++) {
		st_buf[i] = slack_buf[i];
	}
	for(i=IMAGE_SLACK_NUMBER;i<IMAGE_MAX_SIZE;i++) {
		st_buf[i] = malloc(IMAGE_BUF_SIZE);
	}
#endif
	return 0;
}

void *STATIC_malloc(int size)
{
	int i;

	if (size != IMAGE_BUF_SIZE) {
		if (size >= 512*1024) printf("In %s:%d:  Alloc %d bytes\n", __FUNCTION__, __LINE__, size);
		return malloc(size);
	}
	
	for(i=0;i<IMAGE_MAX_SIZE;i++)
		if (buf_pool[i]==0) break;
	
	if (i == IMAGE_MAX_SIZE) {
			return malloc(size);
	}
	
	buf_pool[i] = 1;
	return st_buf[i];
}

void STATIC_free(void *p)
{
	int i;

	for(i=0;i<IMAGE_MAX_SIZE;i++) {
		if (st_buf[i] == p) {
			buf_pool[i] = 0;
			return;	
		}
	}
	free(p);
}
