/*
 * arch/arm/mach-em86xx/arch.c
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 *
 * by Ho Lee 01/27/2003
 */
#include <linux/config.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <asm/arch/em86xxapi.h>
#include <asm/arch/param.h>
#ifdef	CONFIG_ALPHA_PM
#include <linux/pm.h>
#endif	// CONFIG_ALPHA_PM

/* The size of memory used by kernel */
unsigned long em86xx_kmemsize = DRAM_SIZE;

#ifdef CONFIG_SD_USE_BOOTLOADER_MEMCFG
memcfg_t *em86xx_memcfg_ptr = (memcfg_t *)MEMCFG_START;
#else /* ! CONFIG_SD_USE_BOOTLOADER_MEMCFG */
static memcfg_t em86xx_memcfg = {
	signature: MEMCFG_SIGNATURE,
	dram0_size: DRAM_SIZE,
#ifdef CONFIG_NUMA_EM86XX
	dram1_size: DRAM_SIZE_2,
#else
	dram1_size: 0,
#endif
	dram2_size: 0,
	dram0_removable_topreserved: 0,
	dram1_removable_topreserved: 0,
	dram2_removable_topreserved: 0,
	dram0_fixed_topreserved: 0,
	dram1_fixed_topreserved: 0,
	dram2_fixed_topreserved: 0,
	kernel_end: 0x00080000,	/* By default reserve first 512KB in DRAM0 */
	checksum: 0,	/* Not a valid checksum */
	reserved: {0, 0, 0, 0},
};
memcfg_t *em86xx_memcfg_ptr = (memcfg_t *)&em86xx_memcfg;
#endif /* CONFIG_SD_USE_BOOTLOADER_MEMCFG */

#ifdef	CONFIG_ALPHA_PM
typedef struct bootflag_t {
	char magic[9];
	int  flag;
} bootflag;

void	em86xx_power_off( void )
{
#ifdef	CONFIG_TARGET_BOARD_X2PLUS
	em86xx_gpio_setdirection( 15, 1); // Set to output
	em86xx_gpio_write( 15, 0);	// Drive the pin low
#elif defined (CONFIG_TARGET_BOARD_LFBOX)
	em86xx_gpio_setdirection(12, 1); /* Set to output */
	em86xx_gpio_write(12, 0);
	printk("Power Off!\n");
	while(1)
		;
#else

	bootflag *bootflag_addr=(bootflag *)0x93ffff00;
	bootflag_addr->magic[0]='0';
	bootflag_addr->magic[1]='0';
	bootflag_addr->magic[2]='0';
	bootflag_addr->magic[3]='0';
	bootflag_addr->magic[4]='0';
	bootflag_addr->magic[5]='0';
	bootflag_addr->magic[6]='0';
	bootflag_addr->magic[7]='0';
	bootflag_addr->magic[8]='\0';
	bootflag_addr->flag=1;
	// old DSM520x hardware configuration
	em86xx_gpio_setdirection(2, 1); /* Set to output */
	em86xx_gpio_write(2, 0);
	// new DSM520x hardware configuration
	em86xx_gpio_setdirection(15, 1); /* Set to output */
	em86xx_gpio_write(15, 0);

#endif	// CONFIG_TARGET_BOARD_X2PLUS
}
#endif	// CONFIG_ALPHA_PM

extern void em86xx_init_irq(void);

static void __init em86xx_fixup(struct machine_desc *desc, struct param_struct *unusd,
    char **cmdline, struct meminfo *mi)
{
    unsigned int revid = __raw_readl(REG_BASE_HOST + PCI_devcfg_reg1) & 0x0f;
	
#ifdef CONFIG_TARGET_BOARD_LFBOX
/* This code is removed due to some reason
   The HW has changed that wireless lan driver can not to be turn on/off
 */
/* wireless lan power on */
//	printk("power on wireless lan pwr (gpio 5 to be high)\n");
//	em86xx_gpio_setdirection( 5, 1); // Set to output
//	em86xx_gpio_write( 5, 1);	// Drive the pin low
#endif
#ifdef	CONFIG_ALPHA_PCA9555
	pca9555_init();
	pca9555_reg_get_set(0x2000,0x0,1);
	pca9555_reg_get_set(0x0001,0x0,1);
	pca9555_reg_get_set(0x0020,0x0,1);
	pca9555_reg_get_set(0x0080,0x0,1);
#endif	// CONFIG_ALPHA_PCA9555

#ifdef	CONFIG_ALPHA_ADM530_RESET_GL816E	
	em86xx_gpio_setdirection( 2,1 );
	em86xx_gpio_write( 2,1 );
#endif	// CONFIG_ALPHA_ADM530_RESET_GL816E

#if defined(CONFIG_ARCH_MAMBO)
    printk("Mambo Rev %c (kernel supports Rev %c)\n", 
        'A' + revid - 1, 'A' + CONFIG_ARCH_MAMBO_REV - 1);
#elif defined(CONFIG_ARCH_TANGO10)
    // No Rev. B
    if (revid >= 2)
        ++revid;
    printk("Tango10 Rev %c (kernel supports Rev %c)\n", 
        'A' + revid - 1, 'A' + CONFIG_ARCH_TANGO10_REV - 1);
#elif defined(CONFIG_ARCH_TANGO15)
    printk("Tango15 Rev %c (kernel supports Rev %c)\n", 
        'A' + revid - 1, 'A' + CONFIG_ARCH_TANGO15_REV - 1);
#endif
    printk("Board name is %s\n", CONFIG_ARCH_EM86XX_BOARD);
    
    em86xx_sbox_init();
#ifdef	CONFIG_ALPHA_PM
    pm_power_off = em86xx_power_off;
#endif	// CONFIG_ALPHA_PM
}

MACHINE_START(EM86XX, "EM86XX")
    MAINTAINER("Craig Qu - Sigma Designs, Inc")
    BOOT_MEM(PHYS_OFFSET, PHYS_OFFSET, PHYS_OFFSET) // phys_ram, phys_io, virt_io
                                                    // phys_io, virt_io have no meaning
                                                    // but if virt_io is less than 0x00040000, kernel doesn't boot
                                                    // (refer __lookup_architecture_type() at head-armv.S
                                                    // r7 = (virt_io >> 18) 
    INITIRQ(em86xx_init_irq)
    FIXUP(em86xx_fixup)
    BOOT_PARAMS(DRAM_BASE + 0x200)
MACHINE_END
