/*
 * arch/arm/mach-em86xx/em86xxapi.c
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 *
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/hardware.h>
#include <asm/io.h>
#include <asm/arch/em86xxapi.h>
#include <linux/irq.h>
#include <linux/sched.h>

static inline unsigned long em86xx_getxtal(void)
{
	return(__raw_readl(REG_BASE_SYSTEM + SYS_xtal_in_cnt));
}

/* This is the replacement of Linux's udelay. */
void udelay(unsigned usec)
{
	/* SYS_xtal_in_cnt is a counter running off 27MHz, so 1 usec
           is roughly equivalent to 27 increase of count */
	unsigned long start = em86xx_getxtal();
	unsigned long end = start + (usec * 27);

	if (end <= start) 
		/* Handle overflow condition */
		while (em86xx_getxtal() > start);
	while (em86xx_getxtal() < end);
}

void em86xx_syncwith_xtal(unsigned long *mark, unsigned usec)
{
	unsigned long end = *mark + (usec * 27);
	if (end > *mark)
		/* Handle overflow condition */
		while (em86xx_getxtal() > *mark);
	while (em86xx_getxtal() < end);
	*mark = end;
}

