/*
 * arch/arm/mach-em86xx/time.c
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 *
 * by Ho Lee 01/27/2003
 */

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/io.h>

unsigned long offsetref;

void em86xx_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
    offsetref = __raw_readl(REG_BASE_SYSTEM + SYS_xtal_in_cnt);

    // call timer interrupt handler
    do_timer(regs);

    // clear the timer interrupt
    __raw_writel(1, REG_BASE_CPU + CPU_timer0_clr);
}
