/*
 * arch/arm/mach-em86xx/uart.c
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * UART Input/Output
 *
 * This is for debug purpose
 * modified from EM86XX boot loader by Ho Lee 01/29/2003
 */

#include <linux/config.h>
#include <linux/kernel.h>

#include <asm/io.h>
#include <asm/hardware.h>

#define UART1_BASE              (REG_BASE_CPU + CPU_uart0_base)
#define UART2_BASE              (REG_BASE_CPU + CPU_uart1_base)

#define UART_RBR                0x00
#define UART_TBR                0x04
#define UART_IER                0x08
#define UART_IIR                0x0C
#define UART_FCR                0x10
#define UART_LCR                0x14
#define UART_MCR                0x18
#define UART_LSR                0x1C
#define UART_MSR                0x20
#define UART_SCRATCH            0x24
#define UART_CLKDIV             0x28
#define UART_CLKSEL             0x2C

static unsigned int g_uartbase = UART1_BASE;

void uart_putc(int ch)
{
    while ((__raw_readl(g_uartbase + UART_LSR) & 0x20) == 0)
        ;
    __raw_writel(ch, g_uartbase + UART_TBR);
}

void uart_puts(const char *t)
{
    while (*t) {
        if (*t == '\n')
            uart_putc('\r');
        uart_putc(*t++);
    }
}

void uart_putns(const char *t, int maxlen)
{       
    while (maxlen-- && *t) {
        if (*t == '\n')
            uart_putc('\r');
        uart_putc(*t++);
    }
}

int uart_printf(const char *fmt, ...)
{
    char buf[256];

    va_list args;
    int i;

    va_start(args, fmt);
    i = vsprintf(buf, fmt, args); /* hopefully i < sizeof(buf) */
    va_end(args);

    uart_puts(buf);
    
    return i;
}

int uart_getc(void)
{
    while ((__raw_readl(g_uartbase + UART_LSR) & 0x01) == 0)
        ;
    return __raw_readl(g_uartbase + UART_RBR);
}

char *uart_gets_raw(char *str, int maxlen)
{
    int pos = 0;
    int ch;
        
    if (maxlen < 0)
        maxlen = 256;

    for (;;) {
        ch = uart_getc();
        if (pos < maxlen - 2)
            str[pos++] = ch;
        if (ch == '\r' || ch == '\n')
            break;
    }

    str[pos] = 0;
    
    return str;
}

void uart_pause(void)
{
    char str[128];

    uart_puts("<pause>\n");
    uart_gets_raw(str, sizeof str);
}
