/*****************************************
 *  Copyright  2005
 *  REDSonic, Inc. All Rights Reserved
 *  Proprietary and Confidential
 *  Author: Steven Wang
 *  Change Log:
 *	Author		  date	   	comment		
 *      Steven Wang       2005/3/16	Initial Design
 *  	Chunhui Lee	  2005/3/31	Interrupt trigger 
 *	Eddie		  2006/5/12	support LFBox
 ******************************************/

#include <linux/init.h>
#include <linux/slab.h>
#include <linux/irq.h>
#include <linux/devfs_fs_kernel.h>
#include <linux/poll.h>
#include <asm/hardware.h>
#include <linux/spinlock.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/kmod.h>
#include "gpio_em86xx.h"

DECLARE_MUTEX( i2c_lock );
#define	EM86XX_I2C_LOCK		_IO('s', 50)
#define	EM86XX_I2C_UNLOCK	_IO('s', 51)


#define COUNT_PER_SEC 2
#if defined (CONFIG_TARGET_BOARD_X2PLUS)
#define FACTORT_DEFAULT_BUTTON_PRESS_COUNT 5*COUNT_PER_SEC
#elif	defined (CONFIG_TARGET_BOARD_DSM520) || \
	defined (CONFIG_TARGET_BOARD_DSM5208R) || \
	defined (CONFIG_TARGET_BOARD_DVBT) ||	\
	defined (CONFIG_TARGET_BOARD_DSM520RD) || \
	defined (CONFIG_TARGET_BOARD_LFBOX)
#define FACTORT_DEFAULT_BUTTON_PRESS_COUNT 1
#endif

#define CONFIG_FACTORY_DEFAULT_ONLY
struct io_expander_priv {
	io_expander_state_t state;
	spinlock_t *mutex;
	spinlock_t _spinlock;
	wait_queue_head_t wq;
};
struct io_expander_priv io_expander_priv;
#define RUN_AT(x) (jiffies + (x))
struct timer_list led_status_flash_timer;
//#define DEBUG_GPIO

/* The major device number and name */
#ifdef CONFIG_DEVFS_FS
#define GPIO_DEV_MAJOR		0
#else
//#define GPIO_DEV_MAJOR		127	/* May need to be changed?? */
#endif
#define GPIO_DEV_NAME		"gpio"
#define CONFIG_FACTORY_DEFAULT_ONLY
typedef struct rbwdg_thread
{  
	struct task_struct *thread;        // Linux task structure of thread
        /* Task queue need to launch thread */
//        struct tq_struct tq;
        /* function to be started as thread */
//        struct semaphore startstop_sem;

	wait_queue_head_t queue;
	struct completion thr_exited;
	int time_to_die;
	int factory_default_setting_sem;
	int reboot_sem;
} rbwdg_thread_t;

rbwdg_thread_t rbwdg_thread;

/* Some prototypes */
static int open(struct inode *, struct file *);
static int release(struct inode *, struct file *);
static int read(struct file *, char *, size_t, loff_t *);
static int ioctl(struct inode *, struct file *, unsigned int, unsigned long);
static unsigned int poll(struct file *, struct poll_table_struct *);

extern void irda_send_power_button_pressed_key(void);
extern void irda_send_reboot_signal(void);
extern void em86xx_gpio_setdirection(int gpio, int dir);
extern int em86xx_gpio_read(int gpio);
extern void em86xx_gpio_write(int gpio, int data);
/* Global data */
#ifdef CONFIG_DEVFS_FS
static devfs_handle_t devfs_handle = NULL;
#endif
static char *gpio_devname = GPIO_DEV_NAME;
static int gpio_major = GPIO_DEV_MAJOR;
//static int gpio_irq = IRQ_EXTERNAL;



static struct file_operations gpio_fops = {
	open: open,
	read: read,
	ioctl: ioctl,
	poll: poll,
	release: release,
	owner: THIS_MODULE,
};

/* Reading data */
static int read(struct file *fptr, char *bufptr, size_t size, loff_t *fp)
{
	return 0;
}

#ifdef CONFIG_ALPHA_PCA9555
static void led_status_flash_timer_handler(unsigned long data)
{
	static int lights=0;
	//unsigned char data;
	//int address;
	//void    *pca9555_chip = NULL;
	//pca9555_chip = em86xx_i2c_init( 0x45, 0x44, 0);
	
	if( lights ){
		/* network led off */
        //down( &device_sem);
        //spin_lock_irq( &ioexp_lock );

			pca9555_reg_get_set(0x2000,0x2000,1);
			//data = em86xx_read( pca9555_chip, 3, &data, 1);
			//data |= 0x20;
        		//em86xx_write( pca9555_chip, 3, &data, 1);
        //spin_unlock_irq( &ioexp_lock );
        //up( &device_sem);

	}
	else{
		/* network led on */
        //down( &device_sem);
        //spin_lock_irq( &ioexp_lock );

			pca9555_reg_get_set(0x2000,0x0,1);
			//data = em86xx_read( pca9555_chip, 3, &data, 1);
			//data &= 0xdf;
        		//em86xx_write( pca9555_chip, 3, &data, 1);
        //spin_unlock_irq( &ioexp_lock );
        //up( &device_sem);

	}
	lights=1-lights;

	led_status_flash_timer.expires = RUN_AT(2);
	add_timer(&led_status_flash_timer);


}
#endif //CONFIG_ALPHA_PCA9555
/* ioctl function */
static int ioctl(struct inode *inode, struct file *fptr, unsigned int cmd, unsigned long arg)
{
	volatile unsigned long *i2c_master_config_ptr;
	int retval=0;
	int i;

	switch ( cmd ) {
#ifdef CONFIG_TARGET_BOARD_LFBOX
		case PAL_NTSC_L:
		{
			int status;
			em86xx_gpio_setdirection( 2, 0);
			status=em86xx_gpio_read(2);
			copy_to_user((void *)arg,&status,sizeof(status));
		}
			break; 
		case ENET_DET:
		{
			int status;
			em86xx_gpio_setdirection(9, 0);
			status=em86xx_gpio_read(9);
			copy_to_user((void *)arg, &status,sizeof(status));
		}
			break; 
		case EXTER_IR_DECT:
		{
			int status;
			em86xx_gpio_setdirection( 6, 0);
			status=em86xx_gpio_read(6);
			copy_to_user((void*)arg, &status,sizeof(status));
		}
			break; 
		case MUTE:
		{
			int status;
			em86xx_gpio_setdirection( 3, 1);
			copy_from_user(&status,(void*)arg,sizeof(status));
    			em86xx_gpio_write(3, status);
		}
			break; 
		case WIRELESS_PWR:
		{
			int status;
			em86xx_gpio_setdirection( 5, 1);
			copy_from_user(&status,(void*)arg,sizeof(status));
    			em86xx_gpio_write(5, status);
		}
			break; 
		case GPIO_GET_SET:
		{
			GPIO_CMD cmd;
			copy_from_user(&cmd,(void *)arg,sizeof(cmd));
			if(cmd.dir){
				em86xx_gpio_setdirection(cmd.gpio, 1);
    				em86xx_gpio_write(cmd.gpio,cmd.val);
			}
			else{
				em86xx_gpio_setdirection( cmd.gpio, 0);
    				cmd.val=em86xx_gpio_read(cmd.gpio);
				copy_to_user((void *)arg, &cmd,sizeof(cmd));
			}
		}
			break;
#endif
		default:
			retval = -EINVAL;
	}

	return retval;
}

/* Poll function */
static unsigned int poll(struct file *fptr, struct poll_table_struct *ptable)
{
#if 0
	struct ir_private *priv = (struct ir_private *)fptr->private_data;
	unsigned int mask = 0;

	poll_wait(fptr, &ir_wq, ptable);
	if (priv->c_idx != priv->p_idx)
		mask |= (POLLIN | POLLRDNORM);
#endif
	unsigned int mask = 0;
	return(mask);
}

/* Open the device */
static int open(struct inode *inode_ptr, struct file *fptr)
{
	MOD_INC_USE_COUNT;
	return(0);
}

/* Close the device */
static int release(struct inode *inode_ptr, struct file *fptr) 
{
	MOD_DEC_USE_COUNT;
	return(0);
}

#ifdef	CONFIG_EM86XX_VFD_DSM520RD_BUTTONS_ON_PCA9555
extern	void	irda_send_keypad_signal( unsigned char scancode);
#endif	// CONFIG_EM86XX_VFD_DSM520RD_BUTTONS_ON_PCA9555
static int rbwdg_kernel_thread (void *data)
{
	unsigned long timeout;
#ifndef CONFIG_EM86XX_PIO_EXPANDER_INTERRUPT_TRIGGER
	unsigned short port_data;
#endif
	static int count=0;
#ifdef	CONFIG_EM86XX_VFD_DSM520RD_BUTTONS_ON_PCA9555
	int	vfd_prev_sent = 0;
	int	vfd_next_sent = 0;
	int	vfd_stop_sent = 0;
	int	vfd_pause_sent = 0;
	int	vfd_eject_sent = 0;
#endif	// CONFIG_EM86XX_VFD_DSM520RD_BUTTONS_ON_PCA9555

	daemonize ();
	reparent_to_init();

	init_completion (&rbwdg_thread.thr_exited);

	spin_lock_irq(&current->sigmask_lock);

	sigemptyset(&current->blocked);
	recalc_sigpending(current);
	init_waitqueue_head(&rbwdg_thread.queue);

	spin_unlock_irq(&current->sigmask_lock);

	rbwdg_thread.thread = current ;
	strcpy (current->comm, "rbwdg" );

	rbwdg_thread.factory_default_setting_sem=0;
	rbwdg_thread.reboot_sem=0;

	while (1){
		do {
      		  // wake it up after timeout 1 seconds
			timeout = interruptible_sleep_on_timeout (&rbwdg_thread.queue, HZ/COUNT_PER_SEC );
		} while (!signal_pending (current) && (timeout > 0));

		if (signal_pending (current)) {
			spin_lock_irq(&current->sigmask_lock);
			flush_signals(current);
			spin_unlock_irq(&current->sigmask_lock);
		}

		if (rbwdg_thread.time_to_die)
			break;
#ifdef	CONFIG_EM86XX_VFD_DSM520RD_BUTTONS_ON_PCA9555
#define	VFD_BUTTON_DEBOUNCE_JIFFIES	10
		port_data = pca9555_reg_get_set( 0xc608, 0, 0);

		if (!(port_data & (1<<3))) {	// VFD_PREV pressed.
			if (!vfd_eject_sent) { 
				irda_send_keypad_signal( 0x70 );
				vfd_eject_sent = 1;
				printk("\033[44mVFD_EJECT pressed\033[0m\n");
			}
		} else
			vfd_eject_sent = 0;

		if (!(port_data & (1<<9))) {	// VFD_PREV pressed.
			if (!vfd_prev_sent) { 
				irda_send_keypad_signal( 0x49 );
				vfd_prev_sent = 1;
				printk("\033[44mVFD_PREV pressed\033[0m\n");
			}
		} else
			vfd_prev_sent = 0;

		if (!(port_data & (1<<10))) {	// VFD_NEXT pressed.
			if (!vfd_next_sent) { 
				irda_send_keypad_signal( 0x4A );
				vfd_next_sent = 1;
				printk("\033[44mVFD_NEXT pressed\033[0m\n");
			}
		} else
			vfd_next_sent = 0;

		if (!(port_data & (1<<14))) {	// VFD_STOP pressed.
			if (!vfd_stop_sent) { 
				irda_send_keypad_signal( 0x06 );
				vfd_stop_sent = 1;
				printk("\033[44mVFD_STOP pressed\033[0m\n");
			}
		} else
			vfd_stop_sent = 0;

		if (!(port_data & (1<<15))) {	// VFD_PAUSE pressed.
			if (!vfd_pause_sent) { 
				irda_send_keypad_signal( 0x1e );
				vfd_pause_sent = 1;
				printk("\033[44mVFD_PAUSE pressed\033[0m\n");
			}
		} else
			vfd_pause_sent = 0;

#endif	// CONFIG_EM86XX_VFD_DSM520RD_BUTTONS_ON_PCA9555

#ifndef CONFIG_EM86XX_PIO_EXPANDER_INTERRUPT_TRIGGER
/* power btn */
#ifdef CONFIG_ALPHA_PCA9555	
		port_data=pca9555_reg_get_set(0x1800,0,0);
		//printk("port_data =%x\n",port_data);
		if ((port_data&0x800)==0){
			irda_send_power_button_pressed_key();
		}

		//printk("port1_data=0x%x\n",port1_data);
		//printk("port1_data=0x%x\n",port1_data&0x10);
		// if Reset to Default button is pressed, then reset configuration to default values
/* factory reset btn */
		if ((port_data&0x1000) == 0){
			count++;
  		}else 
			count = 0;
		if(count==FACTORT_DEFAULT_BUTTON_PRESS_COUNT)
			rbwdg_thread.factory_default_setting_sem=1;
#endif /* CONFIG_ALPHA_PCA9555 */
#ifdef CONFIG_TARGET_BOARD_LFBOX
		{ /* watchdog timer toggle  */
			static int toggle=0;
			em86xx_gpio_setdirection( 13, 1);
			em86xx_gpio_write(13, toggle);
			toggle=1-toggle;
		}


                /* moniter factory reset button */
		em86xx_gpio_setdirection( 14, 0);
		if ((em86xx_gpio_read(14)) == 0){
			count++;
  		}else 
			count = 0;
		if(count==FACTORT_DEFAULT_BUTTON_PRESS_COUNT)
			rbwdg_thread.factory_default_setting_sem=1;
#endif

#endif
		if ( rbwdg_thread.factory_default_setting_sem ) {
			printk("\033[44mReset to Default button was pressed.\033[0m\n");  	
			printk("\033[44mReset to Default button was pressed.\033[0m\n");  	
			printk("\033[44mReset to Default button was pressed.\033[0m\n");  	
			printk("\033[44mReset to Default button was pressed.\033[0m\n");  	
#ifdef CONFIG_EM86XX_IR_V2
			irda_send_reboot_signal();
#endif
			call_usermodehelper("/sbin/factory_default_setting", NULL, NULL);
			goto exit;
		}
#ifndef CONFIG_FACTORY_DEFAULT_ONLY
		else if(rbwdg_thread.reboot_sem){
			printk("\033[44mReboot!.\033[0m\n");  	
			printk("\033[44mReboot!.\033[0m\n");  	
			printk("\033[44mReboot!.\033[0m\n");  	
			printk("\033[44mReboot!.\033[0m\n");  	
			//call_usermodehelper("/sbin/reboot", NULL, NULL);
			irda_send_reboot_signal();
			sys_reboot(LINUX_REBOOT_MAGIC1,LINUX_REBOOT_MAGIC2,LINUX_REBOOT_CMD_RESTART , NULL);
			goto exit;
	   
		}      
#endif
	}	
exit: 
	complete_and_exit (&rbwdg_thread.thr_exited, 0);
}

#ifdef CONFIG_EM86XX_PIO_EXPANDER_INTERRUPT_TRIGGER
struct timer_list pca9555_timer;
static void pca9555_timer_handler(unsigned long data)
{
	
	static int counts=1;
	unsigned short port_data;

	printk("counts=%d\n",counts);
	port_data=pca9555_reg_get_set((unsigned short)0x1000,0,0);
	
	if( port_data & 0x1000 ){
		if(counts >=FACTORT_DEFAULT_BUTTON_PRESS_COUNT ){
			printk("default sets A\n");
			goto exit;
			/* default sets */
		}else{
			printk("default sets B\n");
#ifndef CONFIG_FACTORY_DEFAULT_ONLY
			rbwdg_thread.reboot_sem=1;
#endif
			counts=1;
		}

		
	}else {
		if(counts >=FACTORT_DEFAULT_BUTTON_PRESS_COUNT){
			printk("default sets C\n");
			goto exit;
			/* default sets */
		}else{
			printk("default sets D\n");
			counts++;
			//pca9555_timer.expires = RUN_AT(HZ); /* 1 sec. */
			//add_timer(&pca9555_timer);
		}

	}


	return;

exit:
	del_timer_sync(&pca9555_timer);
	rbwdg_thread.factory_default_setting_sem=1;
}
static void pca9555_interrupt_handler(int irq, void *dev_id, struct pt_regs * regs)
{
/* check power button
   If power button is pressed, send it to irda driver and then exit.

*/
	unsigned short port_data;
	port_data=pca9555_reg_get_set(0x1800,0,0);
	printk("port_data =%x\n",port_data);
	if ((port_data&0x800)==0){
		irda_send_power_button_pressed_key();
		return;
	}
/* check factory reset button. If user press 5 seconds, reboot!
*/
	if ((port_data&0x1000) == 0){
		pca9555_timer.expires = RUN_AT(HZ);                /* 1 sec. */
		pca9555_timer.function = &pca9555_timer_handler;    /* timer handler */
		add_timer(&pca9555_timer);
//printk("file=%s function=%s line=%d\n",__FILE__,__FUNCTION__,__LINE__);	
	}
}
#endif

int __init gpio_init_module(void)
{

	int status = 0;
	int rbwd;
	/* Init ioexpander */
/*
	This driver is for Phlips PCA9555 IO expander.
	The Config Register (Reg 6 and 7 should be set in bootloader)

*/
#ifdef CONFIG_EM86XX_I2C_HAL
#ifdef CONFIG_I2C_DEVICES_DETECT
	printk("Detecting I2C Devices...\n");
{
	int device_addr, ret;
	struct i2c I2C;

	I2C.RegBase=REG_BASE_system_block;
	I2C.PioClock=0x0;
	I2C.PioData=0x1;
	I2C.DelayUs=0x2;

	printk("found I2C device:");
	for( device_addr = 0x0; device_addr <= 0xff; device_addr++) {
		I2C.WrAddr=device_addr&0xFE;
		I2C.RdAddr=device_addr|0x01;
		ret = I2C_DEVICE_DETECT(&I2C);
		if ( ret == 0 )
			printk("%x, ", device_addr);
	}
	printk("\n");
}
#endif
#endif //CONFIG_EM86XX_I2C_HAL
#ifdef CONFIG_ALPHA_PCA9555	
#define INITIALIZE_PCA9555_CONFIG_REGISTERS
#ifdef INITIALIZE_PCA9555_CONFIG_REGISTERS
{
	struct i2c I2C;
	unsigned char Byte;

	char config_port0;
	char config_port1;

	unsigned char I2C_WrAddr = PCA9555_WRITE_ADDR;
	unsigned char I2C_RdAddr = PCA9555_READ_ADDR;
	unsigned int Delay = PCA9555_DELAY;
	unsigned char PioClock = 0;
	unsigned char PioData = 1;

	I2C.RegBase=REG_BASE_system_block;
	I2C.PioClock=PioClock;
	I2C.PioData=PioData;
	I2C.DelayUs=Delay;
	I2C.WrAddr=I2C_WrAddr;
	I2C.RdAddr=I2C_RdAddr;
	config_port0=0x0;
	config_port1=0x18;
	//em86xx_i2c_write( 0x45, 0x44, CONFIGURATION_PORT_0, &config_port0, 1);
	I2C_WRITE( &I2C, CONFIGURATION_PORT_0, &config_port0, 1);
	//em86xx_i2c_write( 0x45, 0x44, CONFIGURATION_PORT_1, &config_port1, 1);
	I2C_WRITE( &I2C, CONFIGURATION_PORT_1, &config_port1, 1);
	config_port0=0xAA;
	config_port1=0xAA;
	//em86xx_i2c_read( 0x45, 0x44, CONFIGURATION_PORT_0, &config_port0, 1);
	I2C_READ( &I2C, CONFIGURATION_PORT_0, &config_port0, 1);
	//em86xx_i2c_read( 0x45, 0x44, CONFIGURATION_PORT_1, &config_port1, 1);
	I2C_READ( &I2C, CONFIGURATION_PORT_1, &config_port1, 1);
	//printk("\n\n\nconfig_port0=0x%x\n",config_port0);
	//printk("config_port1=0x%x\n",config_port1);
}
#endif
#endif //CONFIG_ALPHA_PCA9555
	status = register_chrdev(gpio_major, gpio_devname, &gpio_fops);
	if (status < 0) {
		printk(KERN_ERR "%s: cannot get major number\n", gpio_devname); 
		return(status);
	} else if (gpio_major == 0)
		gpio_major = status;	/* Dynamic major# allocation */

	/* reboot watch dog */
	io_expander_priv.state=IO_EXPANDER_READY;
	rbwd = kernel_thread (rbwdg_kernel_thread, 0, CLONE_FS | CLONE_FILES);
	if (rbwd < 0)
		printk (KERN_WARNING "unable to create kernel thread for reboot watch dog\n");

#ifdef CONFIG_EM86XX_PIO_EXPANDER_INTERRUPT_TRIGGER
	if (request_irq(IRQ_GPIO3, &pca9555_interrupt_handler,SA_SHIRQ,"PCA9555 interrupt handler",&pca9555_interrupt_handler))
	{ 	
	      printk ("unable to get IRQ %d .\n",IRQ_GPIO3 );
	      return -EAGAIN;
	}
{
	unsigned int irqstat;
	em86xx_gpio_setdirection(13,0);
	irqstat = __raw_readl(REG_BASE_SYSTEM + SYS_gpio_int);
	printk("irqstat=0x%x\n",irqstat);
	irqstat &=~0xff000000;
	irqstat |=(13<<24);
	__raw_writel(irqstat,REG_BASE_SYSTEM + SYS_gpio_int);
	irqstat = __raw_readl(REG_BASE_SYSTEM + SYS_gpio_int);
	printk("irqstat=0x%x\n",irqstat);
}	
#endif
#ifdef CONFIG_DEVFS_FS
	devfs_handle = devfs_register(NULL, gpio_devname, DEVFS_FL_AUTO_DEVNUM,
				gpio_major, 0, S_IFCHR | S_IRUGO, &gpio_fops, NULL);
	if (devfs_handle == NULL)
		printk(KERN_WARNING "%s: devfs module not registered\n", 
			gpio_devname);
#endif			
#ifdef CONFIG_ALPHA_PCA9555
#ifdef	CONFIG_HT1381_ON_EM86XX_PIO_EXPANDER
	ht1381_init();
#endif	// CONFIG_HT1381_ON_EM86XX_PIO_EXPANDER
#endif //CONFIG_ALPHA_PCA9555	
	return(0);
}

void __exit gpio_cleanup_module(void)
{
	rbwdg_thread.time_to_die=1;
	wait_for_completion(&rbwdg_thread.thr_exited);
#ifdef CONFIG_EM86XX_PIO_EXPANDER_INTERRUPT_TRIGGER
	free_irq(IRQ_GPIO3, &pca9555_interrupt_handler);
#endif
	del_timer(&led_status_flash_timer);
	/* Do nothing is CONFIG_DEVFS_FS is not enabled */
#ifdef CONFIG_DEVFS_FS
	if (devfs_handle != NULL)
		devfs_unregister(devfs_handle);
#endif
	unregister_chrdev(gpio_major, gpio_devname);
#ifdef CONFIG_ALPHA_PCA9555	
#ifdef	CONFIG_HT1381_ON_EM86XX_PIO_EXPANDER
	ht1381_exit();
#endif	// CONFIG_HT1381_ON_EM86XX_PIO_EXPANDER
#endif  // CONFIG_ALPHA_PCA9555
}

module_init(gpio_init_module);
module_exit(gpio_cleanup_module);
MODULE_DESCRIPTION("EM86xx gpio io expander driver\n");
MODULE_AUTHOR("Steven Wang");
MODULE_LICENSE("Proprietary, Copyright (c) 2005 REDSonic Inc. All rights reserved.");
