#ifndef __LED_API_H_ 

typedef enum {
        IO_EXPANDER_READY,
        IO_EXPANDER_BUSY
} io_expander_state_t;
typedef struct {
	int dir;
	int gpio;
	int val;
}GPIO_CMD;

#define LED_IOC_MAGIC           's'
#define POWER_LED_A_ON		_IO(LED_IOC_MAGIC, 0)
#define POWER_LED_A_OFF		_IO(LED_IOC_MAGIC, 1)
#define POWER_LED_G_ON		_IO(LED_IOC_MAGIC, 2)
#define POWER_LED_G_OFF		_IO(LED_IOC_MAGIC, 3)
#define POWER_LED_STATUS	_IO(LED_IOC_MAGIC, 4)
#define NETWORK_LED_ON 		_IO(LED_IOC_MAGIC, 5)
#define NETWORK_LED_OFF		_IO(LED_IOC_MAGIC, 6)
#define NETWORK_LED_BLINKING	_IO(LED_IOC_MAGIC, 7)
#define SCART_ENABLE		_IO(LED_IOC_MAGIC, 8)
#define SCART_DISABLE		_IO(LED_IOC_MAGIC, 9)
#define SEL_HD_L_ENABLE		_IO(LED_IOC_MAGIC, 11)
#define SEL_HD_L_DISABLE	_IO(LED_IOC_MAGIC, 12)
#define PAL_NTSC_L		_IO(LED_IOC_MAGIC, 13)
#define ASPECT_RATIO_16_9 	_IO(LED_IOC_MAGIC, 14)
#define ASPECT_RATIO_4_3	_IO(LED_IOC_MAGIC, 15)
#define AUDIO_LR		_IO(LED_IOC_MAGIC, 16)
#define AUDIO_7_1		_IO(LED_IOC_MAGIC, 17)
#define TYPE_RGB_OUTPUT		_IO(LED_IOC_MAGIC, 18)
#define TYPE_CVBS_OUTPUT	_IO(LED_IOC_MAGIC, 19)
#define SCT_S_SEL_S_VIDEO	_IO(LED_IOC_MAGIC, 20)
#define SCT_S_SEL_CVBS_RGB	_IO(LED_IOC_MAGIC, 21)
#define EM86XX_I2C_READ		_IO(LED_IOC_MAGIC, 22)
#define EM86XX_I2C_WRITE	_IO(LED_IOC_MAGIC, 23)
#define EM86XX_I2C_READ_NO_SUBADDR	_IO(LED_IOC_MAGIC, 24)
#define EM86XX_I2C_WRITE_NO_SUBADDR	_IO(LED_IOC_MAGIC, 25)
#define EM86XX_I2C_READ_MSP_DSP		_IO(LED_IOC_MAGIC, 26)
#define MUTE		_IO(LED_IOC_MAGIC, 31)
#define ENET_DET	_IO(LED_IOC_MAGIC, 32)
#define EXTER_IR_DECT	_IO(LED_IOC_MAGIC, 33)
#define WIRELESS_PWR    _IO(LED_IOC_MAGIC, 34)
#define GPIO_GET_SET	_IO(LED_IOC_MAGIC, 35)


int acer_gpio_get_set(unsigned short mask, unsigned short value, int get_set);



#endif /* _WCN_LED_API_H_ */
