#include <asm-armnommu/arch-em86xx/emhwlib_registers_tangolight.h>
#include <asm/semaphore.h>
#include <linux/spinlock.h>
#include "pca9555.h"
#include "i2c_hal.h"

struct i2c I2C;

unsigned short	pca9555_gpio_get( unsigned short mask )
{
	unsigned char	IO0_mask;
	unsigned char	IO0_value;
	unsigned char	IO1_mask;
	unsigned char	IO1_value;
	unsigned char	data;
	int	address;
	unsigned char config0, config1;

	IO0_mask = (unsigned char)(mask & 0xff);
	IO1_mask = (unsigned char)((mask & 0xff00) >> 8);
	
	// read configure port0
	address = 6;
	I2C_READ( &I2C, address, &config0, 1);
	config0 |= (IO0_mask);
	I2C_WRITE( &I2C, address, &config0, 1);
	/*
	 * For port 0
	 */
	// read port0
	address = 0;
	I2C_READ( &I2C, address, &data, 1);
	IO0_value = data & IO0_mask;

	// read configure port1
	address = 7;
	I2C_READ( &I2C, address, &config1, 1);
	config1 |= (IO1_mask);
	I2C_WRITE( &I2C, address, &config1, 1);
		
	/*
	 * For port 1
	 */
	// read port1
	address = 1;
	I2C_READ( &I2C, address, &data, 1);
	IO1_value = data & IO1_mask;

	return (IO1_value << 8) | IO0_value;
}

void	pca9555_gpio_set( unsigned short mask, unsigned short value )
{
	unsigned char	IO0_mask;
	unsigned char	IO0_value;
	unsigned char	IO1_mask;
	unsigned char	IO1_value;
	unsigned char	data;
	int	address;
	unsigned char config0,config1;

	IO0_mask = (unsigned char)(mask & 0xff);
	IO0_value = (unsigned char)(value & 0xff);
	IO1_mask = (unsigned char)((mask & 0xff00) >> 8);
	IO1_value = (unsigned char)((value & 0xff00) >> 8);

	// read configure port0
	address = 6;
	I2C_READ( &I2C, address, &config0, 1);
	config0 &= ~(IO0_mask);
	I2C_WRITE( &I2C, address, &config0, 1);
	
	/*
	 * Set port 0
	 */
	// read port0
	address = 2;
	I2C_READ( &I2C, address, &data, 1);

	data &= ~(IO0_mask);
	data |= IO0_value;

	// write port0
	I2C_WRITE( &I2C, address, &data, 1);

	// read configure port1
	address = 7;
	I2C_READ( &I2C, address, &config1, 1);
	config1 &= ~(IO1_mask);
	I2C_WRITE( &I2C, address, &config1, 1);
	/*
	 * Set Port 1
	 */
	// read port1
	address = 3;
	I2C_READ( &I2C, address, &data, 1);
	data &= ~(IO1_mask);
	data |= IO1_value;

	// write port1
	I2C_WRITE( &I2C, address, &data, 1);
}
extern	struct  semaphore       i2c_lock;

unsigned short pca9555_reg_get_set(unsigned short mask, unsigned short value, int get_set){
	int retv=0;
	down( &i2c_lock );
	if(get_set==1){
		pca9555_gpio_set(mask,value);
	}else{
		retv=pca9555_gpio_get(mask);
	}
	up( &i2c_lock );
	return retv;
}

void pca9555_init(void)
{	
	// defaults
	unsigned char I2C_WrAddr = PCA9555_WRITE_ADDR;
	unsigned char I2C_RdAddr = PCA9555_READ_ADDR;
	unsigned int Delay = PCA9555_DELAY;
	unsigned char PioClock = 0;
	unsigned char PioData = 1;

	printk("Init PCA9555: %s\n", __FUNCTION__);
	I2C.RegBase=REG_BASE_system_block;
	I2C.PioClock=PioClock;
	I2C.PioData=PioData;
	I2C.DelayUs=Delay;
	I2C.WrAddr=I2C_WrAddr;
	I2C.RdAddr=I2C_RdAddr;

	pca9555_reg_get_set(0xffff,0xffff,1);

}	
