/*
 * driver/ide/em86xx/em86xx_ide.h
 * 
 * EM86XX IDE driver common code
 *
 * by Ho Lee March 4, 2003
 */

#ifndef __EM86XX_IDE_H
#define __EM86XX_IDE_H

/* If bounce buffer is used, use it in non-cached region */
#define EM86XX_BOUNCE_BUFFER_NOCACHE

// Basic I/O
void em86xx_ide_OUTB(u8 data, unsigned long port);
void em86xx_ide_OUTBSYNC(ide_drive_t *drive, u8 data, unsigned long port);
u8 em86xx_ide_INB(unsigned long port);

// DMA handlers
int em86xx_ide_dma_on(ide_drive_t *drive);
int em86xx_ide_dma_off(ide_drive_t *drive);
int em86xx_ide_dma_off_quietly(ide_drive_t *drive);
int em86xx_ide_dma_test_irq(ide_drive_t *drive);
int em86xx_ide_dma_bad_drive(ide_drive_t *drive);
int em86xx_ide_dma_good_drive(ide_drive_t *drive);
int em86xx_ide_dma_count(ide_drive_t *drive);
int em86xx_ide_dma_verbose(ide_drive_t *drive);
int em86xx_ide_dma_retune(ide_drive_t *drive);
int em86xx_ide_dma_lostirq(ide_drive_t *drive);
int em86xx_ide_dma_timeout(ide_drive_t *drive);

// helper functions
void em86xx_ide_dma_cache(struct request *rq, int do_clean, int do_invalidate);
int em86xx_ide_config_drive_for_dma(ide_drive_t *drive, int mode);

#endif
