/*
 * driver/ide/em86xx/generic_pci.c
 * 
 * Support for PCI IDE controller on EM86XX PCI bus
 *
 * by Ho Lee 09/11/2003
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <asm/io.h>
#include <asm/hardware.h>
#include <linux/ide.h>

void ide_init_hwif_ports(hw_regs_t *hw, ide_ioreg_t data_port, ide_ioreg_t ctrl_port, int *irq)
{

#ifdef CONFIG_BLK_DEV_IDEPCI 
    int i;
    ide_ioreg_t reg;

    // setup io_ports
    for (i = IDE_DATA_OFFSET, reg = data_port; i <= IDE_STATUS_OFFSET; i++) {
        hw->io_ports[i] = reg;
        reg += 1;
    }
    if (ctrl_port)
        hw->io_ports[IDE_CONTROL_OFFSET] = (ide_ioreg_t) ctrl_port;
    if (irq != NULL)
        *irq = 0;
    hw->io_ports[IDE_IRQ_OFFSET] = 0;
#endif
}

void ide_init_default_hwifs(void)
{
}

