/*
 * include/asm-arm/arch-em86xx/board-generic/mtdpartitions.h
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * Sigma Designs Evaluation Boards
 */

#ifndef __ASM_ARCH_BOARD_MTDPARTITIONS_H
#define __ASM_ARCH_BOARD_MTDPARTITIONS_H

#include <asm/arch/boardname.h>

#ifdef CONFIG_MTD_PARTITIONS

#define EM86XX_MTD_PARTITIONS \
    /* Assume 4MB flash memory */ \
    { /* 3840KB read-only */ \
        name: "RootFS", \
        size: 0x3c0000, \
        offset: 0x10000 + 0x20000, \
        mask_flags: MTD_WRITEABLE, /* Not writable */ \
    }, \
    { /* 64KB read/write */ \
        name: "User", \
        size: 0x10000, \
	offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }
    /* 64KB (0x10000) is first stage loader */ \
    /* 128KB (0x20000) is second stage loader */ 
#endif
#endif

