/*
 * include/asm-arm/arch-em86xx/board-generic/mtdpartitions.h
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * Sigma Designs Evaluation Boards
 */

#ifndef __ASM_ARCH_BOARD_MTDPARTITIONS_H
#define __ASM_ARCH_BOARD_MTDPARTITIONS_H

#include <asm/arch/boardname.h>

#ifdef CONFIG_MTD_PARTITIONS

#ifdef CONFIG_ALPHA_MTD_NEW_PARTITIONS 
#define EM86XX_MTD_PARTITIONS \
    /* Assume 8MB flash memory */ \
    { /* 56KB readonly: bootloader */ \
        name: "BootLoader", \
        size: 0xe000, \
        offset: 0, \
        mask_flags: 0, \
    }, \
    { /* 8KB read/write */ \
        name: "Config", \
        size: 0x2000, \
        offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }, \
    { /* 7.9375MB read/write */ \
        name: "Romfs", \
        size: 0x7f0000, \
        offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }, 
#elif defined(CONFIG_ALPHA_MTD_16MB_FLASH)
#define EM86XX_MTD_PARTITIONS \
    /* Assume 16MB flash memory */ \
    { /* 56KB readonly: bootloader */ \
        name: "BootLoader", \
        size: 0x20000, \
        offset: 0, \
        mask_flags: 0, \
    }, \
    { /* 8KB read/write */ \
        name: "Config", \
        size: 0x20000, \
        offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }, \
    { /* 7.9375MB read/write */ \
        name: "Romfs", \
        size: 0xfc0000, \
        offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }, 
#else

#define EM86XX_MTD_PARTITIONS \
    /* Assume 4MB flash memory */ \
    { /* 3840KB read/write */ \
        name: "RootFS", \
        size: 0x3c0000, \
        offset: 0x10000 + 0x20000, \
        mask_flags: 0, \
    }, \
    { /* 64KB read/write */ \
        name: "User", \
        size: 0x10000, \
        offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }, \
    { /* 64KB readonly: first stage bootloader */ \
        name: "BootROM1", \
        size: 0x10000, \
        offset: 0x0, \
        mask_flags: MTD_WRITEABLE, /* Not writable */ \
    }, \
    { /* 128KB: second stage bootloader */ \
        name: "BootROM2", \
        size: 0x20000, \
        offset: 0x10000, \
        mask_flags: 0, \
    },


#endif // NEW_PARTITIONS_MAP
#endif

#endif
