/*
 * include/asm-arm/arch-em86xx/io.h
 *
 * Copyright 2002-2004, Sigma Designs, Inc 
 *
 * Modifications:
 *  06-12-1997  RMK Created.
 *  07-04-1999  RMK Major cleanup
 *  02-19-2001  gjm Leveraged for armnommu/dsc21
 *  12-13-2001  FG  Forked from atmel to jasper
 *  01-03-2003  Ho Lee Forked from Jasper to EM86XX
*/

#ifndef __ASM_ARCH_IO_H
#define __ASM_ARCH_IO_H

/*
 * kernel/resource.c uses this to initialize the global ioport_resource struct
 * which is used in all calls to request_resource(), allocate_resource(), etc.
 * --gmcnutt
 */
#define IO_SPACE_LIMIT 0xffffffff

/*
 * If we define __io then asm/io.h will take care of most of the inb & friends
 * macros. It still leaves us some 16bit macros to deal with ourselves, though.
 * We don't have PCI or ISA on the dsc21 so I dropped __mem_pci & __mem_isa.
 * --gmcnutt
 */

#ifdef CONFIG_PCI_EM86XX_HOST_FPGA

#ifndef __ASSEMBLY__

#include <asm/arch/pcifpga.h>

// Every read/write transaction must go through the FPGA 
// All inx() and outx() function use these macros
// These macros are common in I/O space and memory space

#define PCIFPGA_RAW_READ_X(x, type, name) \
    static __inline__ unsigned type pcifpga_raw_read##x(unsigned int addr) \
    { \
        if (addr >= PCIFPGA_IO_BASE && addr < PCIFPGA_IO_END) { \
            return pcifpga_in_##name(addr); \
        } else if (addr >= PCIFPGA_MEMORY_BASE && addr < PCIFPGA_MEMORY_END) { \
            return pcifpga_read_##name(addr); \
        } else { \
            volatile unsigned type *ptr = (volatile unsigned type *) (addr); \
            return *ptr; \
        } \
    } 

#define PCIFPGA_RAW_WRITE_X(x, type, name) \
    static __inline__ void pcifpga_raw_write##x(unsigned int data, unsigned int addr) \
    { \
        if (addr >= PCIFPGA_IO_BASE && addr < PCIFPGA_IO_END) { \
            pcifpga_out_##name(data, addr); \
        } else if (addr >= PCIFPGA_MEMORY_BASE && addr < PCIFPGA_MEMORY_END) { \
            pcifpga_write_##name(data, addr); \
        } else { \
            volatile unsigned type *ptr = (volatile unsigned type *) (addr); \
            *ptr = (unsigned type) data; \
        } \
    }

PCIFPGA_RAW_READ_X(b, char, byte)
PCIFPGA_RAW_READ_X(w, short, word)
PCIFPGA_RAW_READ_X(l, int, dword)

PCIFPGA_RAW_WRITE_X(b, char, byte)
PCIFPGA_RAW_WRITE_X(w, short, word)
PCIFPGA_RAW_WRITE_X(l, int, dword)

#define outb(v,p)               pcifpga_raw_writeb(v,(unsigned int) (p))
#define outw(v,p)               pcifpga_raw_writew(v,(unsigned int) (p))
#define outl(v,p)               pcifpga_raw_writel(v,(unsigned int) (p))

#define inb(p)                  pcifpga_raw_readb((unsigned int) (p))
#define inw(p)                  pcifpga_raw_readw((unsigned int) (p))
#define inl(p)                  pcifpga_raw_readl((unsigned int) (p))

#define outsb(p,d,l)            pcifpga_raw_writesb((unsigned int) (p),d,l)
#define outsw(p,d,l)            pcifpga_raw_writesw((unsigned int) (p),d,l)
#define outsl(p,d,l)            pcifpga_raw_writesl((unsigned int) (p),d,l)

#define insb(p,d,l)             pcifpga_raw_readsb((unsigned int) (p),d,l)
#define insw(p,d,l)             pcifpga_raw_readsw((unsigned int) (p),d,l)
#define insl(p,d,l)             pcifpga_raw_readsl((unsigned int) (p),d,l)

#endif // __ASSEMBLY__

#else

// asm/io.h takes care of many functions
#define __io(a)     (a)

#endif // CONFIG_PCI_EM86XX_HOST_FPGA

#define __arch_getw(a)          (*(volatile unsigned short *)(a))
#define __arch_putw(v,a)        (*(volatile unsigned short *)(a) = (v))

#ifdef CONFIG_CPU_PT110

/* 
 * PT110 reads same address twice when a sequenced load instruction is 
 * interrupted by IRQ or FIQ. To read 'action-on-read' registers, 
 * these access should be protected by disabling IRQ/FIQ
 */

#include <asm/proc/system.h>

#undef __raw_readb
#undef __raw_readw
#undef __raw_readl

#define __IRQSAFE_RAW_READ_X(x, type) \
    static __inline__ unsigned type __irqsafe_raw_read##x(unsigned long addr) \
    { \
        unsigned type data; \
        unsigned long flags; \
        __save_flags_clif(flags); \
        data = __arch_get##x(addr); \
        __restore_flags(flags); \
        return data; \
    } \

__IRQSAFE_RAW_READ_X(b, char)
__IRQSAFE_RAW_READ_X(w, short)
__IRQSAFE_RAW_READ_X(l, int)

#define __raw_readb(addr)   __irqsafe_raw_readb((unsigned long) addr)
#define __raw_readw(addr)   __irqsafe_raw_readw((unsigned long) addr)
#define __raw_readl(addr)   __irqsafe_raw_readl((unsigned long) addr)

#endif

/*
 * Defining these two gives us ioremap for free. See asm/io.h.
 * --gmcnutt
 */
#define iomem_valid_addr(iomem,sz) (1)
#define iomem_to_phys(iomem) (em86xx_to_ncaddr(iomem))

/* 
 * PCI memory address space mapping 
 * needed by readx(), writex() series functions defined in asm/io.h
 */

#ifdef CONFIG_PCI_EM86XX_HOST_FPGA

#ifndef __ASSEMBLY__

// Every read/write transaction must go through the FPGA 
// All readx() and writex() function use macros defined before

#define readb(addr)             pcifpga_raw_readb((unsigned int) (addr))
#define readw(addr)             pcifpga_raw_readw((unsigned int) (addr))
#define readl(addr)             pcifpga_raw_readl((unsigned int) (addr))
#define writeb(val,addr)        pcifpga_raw_writeb(val,(unsigned int) (addr))
#define writew(val,addr)        pcifpga_raw_writew(val,(unsigned int) (addr))
#define writel(val,addr)        pcifpga_raw_writel(val,(unsigned int) (addr))

#define memset_io(a,b,c)        pcifpga_memset_io((a),(unsigned long) (b),(c))
#define memcpy_fromio(a,b,c)    pcifpga_memcpy_fromio((unsigned long) (a),(b),(c))
#define memcpy_toio(a,b,c)      pcifpga_memcpy_toio((unsigned long) (a),(b),(c))

#endif // __ASSEMBLY__

#else

// asm/io.h takes care of many functions
#define __mem_pci(a)    ((unsigned long)(a))
    
#endif // CONFIG_PCI_EM86XX_HOST_FPGA

#endif // __ASM_ARCH_IO_H
