/*
 * include/asm-arm/arch-em86xx/system.h
 * 
 * Copyright 2002-2004, Sigma Designs, Inc
 *
 * by Ho Lee 01/27/2003
 */

#ifndef __ASM_ARCH_SYSTEM_H
#define __ASM_ARCH_SYSTEM_H

#include <asm/arch/hardware.h>
#include <linux/pci.h>

static void arch_idle(void)
{
    /*
     * This should do all the clock switching
     * and wait for interrupt tricks
     */
    cpu_do_idle(0);
}

static __inline__ void arch_reset(char mode)
{
#ifdef CONFIG_SD_GPIO_RESET
    const unsigned int pin = CONFIG_SD_GPIO_PIN_TO_RESET;
    unsigned long flags;

    /* Disable interrupt */
    __save_flags_clif(flags);

    em86xx_gpio_setdirection(pin, 1); /* Set to output */
    while (1) {
#ifdef CONFIG_SD_GPIO_PIN_RESET_ACTIVE_H
    	em86xx_gpio_write(pin, 1); /* Drive the pin high */
#else
    	em86xx_gpio_write(pin, 0); /* Drive the pin low */
#ifdef CONFIG_TARGET_BOARD_LFBOX
	mdelay(200);
    	em86xx_gpio_write(pin, 1);
	while (1)
		;
#endif
#endif
    }
#else
    typedef void (*FUNC_PTR)(void);
    unsigned long flags;
	
    /*Disable all pci devices, 
      for reboot problem after loading usb drivers*/	
    pci_disable_device_all();

    /* Disable IRQ/FIQ */
    __save_flags_clif(flags);

    /* Resetting Video block */
    __raw_writel(0x3, REG_BASE_VIDEOOUT + 0xfffc);
    __raw_writel(0x2, REG_BASE_VIDEOOUT + 0xfffc);
  
    /* Resetting MPEG0 block */
    __raw_writel(0x3, REG_BASE_MPEG0 + 0xfffc);
    __raw_writel(0x2, REG_BASE_MPEG0 + 0xfffc);
  
    /* Resetting MPEG1 block */
    __raw_writel(0x3, REG_BASE_MPEG1 + 0xfffc);
    __raw_writel(0x2, REG_BASE_MPEG1 + 0xfffc);
  
    /* Resetting Transport demux block */
    __raw_writel(0x3, REG_BASE_TSDEMUX + 0xfffc);
    __raw_writel(0x2, REG_BASE_TSDEMUX + 0xfffc);

    /* Resetting Audio0 block */
    __raw_writel(0x3, REG_BASE_AUDIO0 + 0xfffc);
    __raw_writel(0x2, REG_BASE_AUDIO0 + 0xfffc);
  
    /* Resetting Audio1 block */
    __raw_writel(0x3, REG_BASE_AUDIO1 + 0xfffc);
    __raw_writel(0x2, REG_BASE_AUDIO1 + 0xfffc);
  
    /* Set remap register to reset state */
#ifdef CONFIG_SD_REBOOT_PARALLEL_FLASH
    __raw_writel(MEMORY_BASE_HOST_PB2, REG_BASE_CPU + CPU_remap);
#else
    __raw_writel(MEMORY_BASE_HOST_SFLASH, REG_BASE_CPU + CPU_remap);
#endif

   
    /* Jump to reset vector */
    (*((FUNC_PTR)0x0))();
#endif
}

#endif
