/*
 * linux/asm/assembler.h
 *
 * This file contains arm architecture specific defines
 * for the different processors.
 *
 * Do not include any C declarations in this file - it is included by
 * assembler source.
 */
#ifndef __ASSEMBLY__
#error "Only include this from assembly code"
#endif

#include <asm/proc/ptrace.h>
#include <asm/proc/assembler.h>

/*
 * Endian independent macros for shifting bytes within registers.
 */
#ifndef __ARMEB__
#define pull            lsr
#define push            lsl
#define byte(x)         (x*8)
#else
#define pull            lsl
#define push            lsr
#define byte(x)         ((3-x)*8)
#endif

#ifdef CONFIG_SD
	.macro save_flags_clif rd, rt
	mrs \rd, cpsr
	mov \rt, \rd
	orr \rt, \rt, #0xc0	@ disable IRQ/FIQ
	msr cpsr_c, \rt
	.endm
	
	.macro save_flags_clf rd, rt
	mrs \rd, cpsr
	mov \rt, \rd
	orr \rt, \rt, #0x40	@ disable FIQ
	msr cpsr_c, \rt
	.endm
	
	.macro save_flags_cli rd, rt
	mrs \rd, cpsr
	mov \rt, \rd
	orr \rt, \rt, #0x80	@ disable IRQ
	msr cpsr_c, \rt
	.endm
	
	.macro restore_flags rd
	msr cpsr_c, \rd
	.endm
#endif

