/*
 * include/asm-arm/arch-em86xx/board-dtv/mtdpartitions.h
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * Sigma Designs Evaluation Boards
 */

#ifndef __ASM_ARCH_BOARD_MTDPARTITIONS_H
#define __ASM_ARCH_BOARD_MTDPARTITIONS_H

#include <asm/arch/boardname.h>

#ifdef CONFIG_MTD_PARTITIONS

#define EM86XX_MTD_PARTITIONS \
    /* Assume 8MB flash memory */ \
    { /* 7936KB read/write */ \
        name: "RootFS", \
        size: 0x7c0000, \
        offset: 0x10000 + 0x20000, \
        mask_flags: 0, \
    }, \
    { /* 64KB read/write */ \
        name: "User", \
        size: 0x10000, \
        offset: MTDPART_OFS_APPEND, \
        mask_flags: 0, \
    }, \
    { /* 64KB readonly: first stage bootloader */ \
        name: "BootROM1", \
        size: 0x10000, \
        offset: 0x0, \
        mask_flags: MTD_WRITEABLE, /* Not writable */ \
    }, \
    { /* 128KB: second stage bootloader */ \
        name: "BootROM2", \
        size: 0x20000, \
        offset: 0x10000, \
        mask_flags: 0, \
    },
#endif

#endif
