/*
 * include/asm-arm/arch-em86xx/board-generic/irqs.h
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * Sigma Designs Evaluation Boards
 */

#ifndef __ASM_ARCH_BOARD_IRQS_H
#define __ASM_ARCH_BOARD_IRQS_H

#include <asm/arch/boardname.h>

// GPIO 6 - IRQ_GPIO0 - IDE_INT (active high)
// GPIO 9 - IRQ_GPIO1 - PCI_INT_A / PCI_INT_B / PCI_INT_C / PCI_INT_D (active low)
// GPIO 9 - IRQ_GPIO1 - PCIFPGA_INT (active high)

#if defined(CONFIG_ARCH_TANGO15) && (CONFIG_ARCH_TANGO15_REV > 1) /* Tango15 RevB or above */
// edge detector configuration
#define BOARDIRQMASK_VALID              ((u64)0xffff00000001e000)
                                        // 1111 1111 1111 1111 ---- ---- ---- ---- - high 32
                                        // 0000 0000 0001 111- ---- ---- ---- ---- - low 32
#define BOARDIRQMASK_RISINGEDGE         ((u64)0x0000000000000000)  
                                        // 0000 0000 0000 0000 ---- ---- ---- ---- - high 32
                                        // ---- ---- ---0 000- ---- ---- ---- ---- - low 32
#define BOARDIRQMASK_FALLINGEDGE        ((u64)0x000000000001c000)
                                        // 0000 0000 0000 0000 ---- ---- ---- ---- - high 32
                                        // ---- ---- ---- ---1 110- ---- ---- ---- - low 32
#define BOARDIRQMASK_LOWLEVEL           ((u64)0x0000000000004000)
                                        // 0000 0000 0000 0000 ---- ---- ---- ---- - high 32
                                        // ---- ---- ---- ---0 010- ---- ---- ---- - low 32
#else
// edge detector configuration
#define BOARDIRQMASK_VALID              0x0001e000  // ---- ---- ---- ---1 111- ---- ---- ----
#define BOARDIRQMASK_RISINGEDGE         0x00000000  // ---- ---- ---- ---0 000- ---- ---- ----
#ifdef CONFIG_PCI_EM86XX_HOST_FPGA
#define BOARDIRQMASK_FALLINGEDGE        0x00018000  // ---- ---- ---- ---1 100- ---- ---- ----
#define BOARDIRQMASK_LOWLEVEL           0x00000000  // ---- ---- ---- ---0 000- ---- ---- ----
#else
#define BOARDIRQMASK_FALLINGEDGE        0x0001c000  // ---- ---- ---- ---1 110- ---- ---- ----
#define BOARDIRQMASK_LOWLEVEL           0x00004000  // ---- ---- ---- ---0 010- ---- ---- ----
#endif
#endif

// board specific interrupts
#define IRQ_IDE                         IRQ_GPIO0
#define IRQ_PCIFPGA                     IRQ_GPIO1

#define SOFTIRQ_PCIFPGA                 14

// PCI interrupt mapping
#define PCI_IRQ_MAP(idsel, irqpin)      IRQ_GPIO1

#endif

