/*
 * include/asm-arm/arch-em86xx/board-generic/mtdpartitions.h
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * Sigma Designs Evaluation Boards
 */

#ifndef __ASM_ARCH_BOARD_MTDPARTITIONS_H
#define __ASM_ARCH_BOARD_MTDPARTITIONS_H

#include <asm/arch/boardname.h>

#ifdef CONFIG_MTD_PARTITIONS

#define EM86XX_MTD_PARTITIONS \
    /* Assume 4MB flash memory */ \
    { /* 3328KB read-only */ \
        name: "RootFS", \
        size: 0x340000, \
        offset: 0x10000 + 0x20000, \
        mask_flags: MTD_WRITEABLE, /* Not writable */ \
    }, \
    { /* 64KB read/write */ \
        name: "User", \
        size: 0x10000, \
        offset: 0x3e0000, \
        mask_flags: 0, \
    }, \
    { /* 512KB read/write */ \
        name: "Keys", \
        size: 0x80000, \
        offset: 0x370000, \
        mask_flags: 0, \
    }, \
    /* 64KB readonly: first stage bootloader */ \
    /* 128KB: second stage bootloader */ 
#endif

#endif
