/*****************************************
 Copyright  2001-2003  
 Sigma Designs, Inc. All Rights Reserved
 Proprietary and Confidential
 *****************************************/
/**
  @file   emhwlib_dram.h
  @brief  

  fm stands for: first megabyte.

  THE CODE USING THESE SYMBOLS ASSUMES THAT THE END BOUNDARY OF AN
  ENTITY IS THE START BOUNDARY OF THE NEXT ENTITY
  
  Regenerate the .inc with:
  
  do not use htoinc.pl  

  do
  grep FM_ emhwlib_dram.h |awk '{ if ($1=="#define") { printf("UNCACHED_%s=0x%08x\n",$2,0x10000000+strtonum($3)); printf("CACHED_%s=0x%08x\n",$2,0x90000000+strtonum($3)); } }' >emhwlib_dram.inc
  
  @author Emmanuel Michon
  @date   2004-07-26
*/

#ifndef __EMHWLIB_DRAM_H__
#define __EMHWLIB_DRAM_H__

#define FM_RESERVED                0x00080000 /* The size resrved */
#define FM_MEMCFG                  0x00000fc0
#define FM_IRQHANDLER_API          0x00001000
#define FM_IRQHANDLER_CODE         0x00011000
#define FM_IRQHANDLER_STACKTOP_USR 0x00040000 /* defined, but never used */
#define FM_IRQHANDLER_STACKTOP_IRQ 0x00048000
#define FM_IRQHANDLER_STACKTOP_FIQ 0x00050000
#define FM_STACKTOP_SVC            0x00058000
#define FM_DRM			   0x00058000
#define FM_BOOTLOADER_CODE         0x00060000

#define MEMCFG_SIGNATURE	0x6766636d // `m' `c' `f' `g'

/* This is the definitive definition of CACHED and UNCACHED for kernel code.
 * Undefine all previous definitions thereof.
 */
#undef CACHED
#undef UNCACHED

#ifdef __ASSEMBLY__

#define CACHED(p)   ((p)|(1<<31))
#define UNCACHED(p) ((p)&(~(1<<31)))

#else /* !__ASSEMBLY__ */

#define CACHED(p)   ((unsigned int)(p)|(1<<31))
#define UNCACHED(p) ((unsigned int)(p)&(~(1<<31)))

/* This is the memory map data structure, the size is 64 bytes */
typedef struct {
    unsigned int signature;
    unsigned int dram0_size;            /* The size of DRAM0 */
    unsigned int dram1_size;            /* The size of DRAM1 */
    unsigned int dram2_size;            /* The size of DRAM2 */
    unsigned int dram0_removable_topreserved;     /* The size of top reserved in DRAM0 */
    unsigned int dram1_removable_topreserved;     /* The size of top reserved in DRAM1 */
    unsigned int dram2_removable_topreserved;     /* The size of top reserved in DRAM2 */
    unsigned int dram0_fixed_topreserved;     /* The size of top reserved in DRAM0 */
    unsigned int dram1_fixed_topreserved;     /* The size of top reserved in DRAM1 */
    unsigned int dram2_fixed_topreserved;     /* The size of top reserved in DRAM2 */
    unsigned int kernel_end;            /* The end address of kernel */
    unsigned int checksum;		    /* The checksum */
    unsigned int reserved[4];           /* Reserved for extension */
} memcfg_t;

#endif /* __ASSEMBLY__ */

#endif // __EMHWLIB_DRAM_H__
 
