/*
 * include/asm-arm/arch-em86xx/pcifpga.h
 *
 * Copyright 2002-2004, Sigma Designs Inc.
 *
 * by Ho Lee 07/14/2003
 */

#ifndef __ASM_ARCH_PCIFPGA_H
#define __ASM_ARCH_PCIFPGA_H

//
// PCI FPGA specific
// 

#define PCIFPGA_IDSEL_FIRST         0x00
#define PCIFPGA_IDSEL_MAX           0x04

#define PCIFPGA_BASE                MEMORY_BASE_HOST_PB3

// Registers
#define PCIFPGA_ISR                 0x00
#define PCIFPGA_READADDR            0x04
#define PCIFPGA_READLEN             0x08
#define PCIFPGA_WRITEADDR           0x0c
#define PCIFPGA_WRITELEN            0x10
#define PCIFPGA_SCRATCH             0x14
#define PCIFPGA_VERSION             0x18
#define PCIFPGA_BYTEENABLE_DMASTART 0x1c
#define PCIFPGA_MEMORYBASE          0x20
#define PCIFPGA_MEMORYMASK          0x24
#define PCIFPGA_IOBASE              0x28
#define PCIFPGA_IOMASK              0x2c
#define PCIFPGA_WRITEDWORDDATA      0x30
#define PCIFPGA_WRITEDWORDCMD       0x34
#define PCIFPGA_WRITEDWORDADDR      0x38
#define PCIFPGA_IRQMASK             0x3c

#define PCIFPGA_IDEREADDATA         0x0100
#define PCIFPGA_PCIREADRESPONSEDATA 0x0200
#define PCIFPGA_PCIWRITEDATA        0x0300

#define PCIFPGA_CONFIG_BASE_0       0x00001000
#define PCIFPGA_CONFIG_BASE_1       0x00002000
#define PCIFPGA_CONFIG_BASE_2       0x00003000
#define PCIFPGA_CONFIG_BASE_3       0x00004000
#define PCIFPGA_CONFIG_END          0x00005000

#define PCIFPGA_IOBASE_ADDR         0x00080000
#define PCIFPGA_IOBASE_VALID        0x01080000
#define PCIFPGA_IOBASE_MASK         0x00f80000
#define PCIFPGA_IOBASE_SIZE         0x00080000

#define PCIFPGA_MEMORYBASE_ADDR     0x00200000
#define PCIFPGA_MEMORYBASE_VALID    0x01200000
#define PCIFPGA_MEMORYBASE_MASK     0x00e00000
#define PCIFPGA_MEMORYBASE_SIZE     0x00200000

#define PCIFPGA_IOMEM_PREFIX        0xef000000
#define PCIFPGA_IO_BASE             (PCIFPGA_IOMEM_PREFIX + PCIFPGA_IOBASE_ADDR)
#define PCIFPGA_IO_END              (PCIFPGA_IO_BASE + PCIFPGA_IOBASE_SIZE)
#define PCIFPGA_MEMORY_BASE         (PCIFPGA_IOMEM_PREFIX + PCIFPGA_MEMORYBASE_ADDR)
#define PCIFPGA_MEMORY_END          (PCIFPGA_MEMORY_BASE + PCIFPGA_MEMORYBASE_SIZE)

// PCIFPGA_ISR
#define PCIFPGA_IRQ_WRREQ           0x0001
#define PCIFPGA_IRQ_RDREQ           0x0002
#define PCIFPGA_IRQ_RDRESP          0x0004
#define PCIFPGA_IRQ_INTA            0x0008
#define PCIFPGA_IRQ_INTB            0x0010
#define PCIFPGA_IRQ_INTC            0x0020
#define PCIFPGA_IRQ_INTD            0x0040
#define PCIFPGA_IRQ_INTMASK         0x0078
#define PCIFPGA_IRQ_ERROR           0x0080
#define PCIFPGA_IRQ_MASTERABORT     0x0100
#define PCIFPGA_IRQ_FIFOBUSY        0x0200

// PCIFPGA_IRQMASK
#define PCIFPGA_IRQMASK_PCIINT      0x0078

// PCIFPGA_BYTEENABLE_DMASTART
#define PCIFPGA_DMASTART_WRITE      0x0010
#define PCIFPGA_DMASTART_READ       0x0020

//
// PCI signal definitions
// 

#define PCI_CMD_IOREAD              0x02
#define PCI_CMD_IOWRITE             0x03
#define PCI_CMD_MEMORYREAD          0x06
#define PCI_CMD_MEMORYWRITE         0x07
#define PCI_CMD_CONFIGREAD          0x0a
#define PCI_CMD_CONFIGWRITE         0x0b

#ifndef __ASSEMBLY__
#include <linux/types.h>

// primitive PCI FPGA I/O
unsigned short __pcifpga_readw(unsigned int addr);
unsigned int __pcifpga_readl(unsigned int addr);
void __pcifpga_writew(unsigned int data, unsigned int addr);
void __pcifpga_writel(unsigned int data, unsigned int addr);

void pcifpga_irqmask_set(int mask);

// primitive PCI I/O Access
unsigned char pcifpga_in_byte(unsigned int addr);
unsigned short pcifpga_in_word(unsigned int addr);
unsigned int pcifpga_in_dword(unsigned int addr);
void pcifpga_out_byte(unsigned int data, unsigned int addr);
void pcifpga_out_word(unsigned int data, unsigned int addr);
void pcifpga_out_dword(unsigned int data, unsigned int addr);

// primitive PCI Memory Access
unsigned char pcifpga_read_byte(unsigned int addr);
unsigned short pcifpga_read_word(unsigned int addr);
unsigned int pcifpga_read_dword(unsigned int addr);
void pcifpga_write_byte(unsigned int data, unsigned int addr);
void pcifpga_write_word(unsigned int data, unsigned int addr);
void pcifpga_write_dword(unsigned int data, unsigned int addr);

// block operations
void pcifpga_memcpy_fromio(void *, unsigned long, size_t);
void pcifpga_memcpy_toio(unsigned long, const void *, size_t);
void pcifpga_memset_io(unsigned long, int, size_t);

// string operations
void pcifpga_raw_readsb(unsigned int addr, void *data, int len);
void pcifpga_raw_readsw(unsigned int addr, void *data, int len);
void pcifpga_raw_readsl(unsigned int addr, void *data, int len);
void pcifpga_raw_writesb(unsigned int addr, void *data, int len);
void pcifpga_raw_writesw(unsigned int addr, void *data, int len);
void pcifpga_raw_writesl(unsigned int addr, void *data, int len);

// miscellaneous
int pcifpga_info(void);

#endif

#endif
