/*****************************************
 Copyright  2004-2005
 Sigma Designs, Inc. All Rights Reserved
 Proprietary and Confidential
 *****************************************/
/**
  @file   emhwlib_lram.h
  @brief  

  Map of the localram

  Even debug locations must be present here

  @author Emmanuel Michon
  @date   2005-03-17
*/

#ifndef __EMHWLIB_LRAM_H__
#define __EMHWLIB_LRAM_H__

#define LR_CPU_IDLELOOP          0x00000000 /* CPU uses 0x80 bytes, up to 0x0080 */
#define LR_STACKTOP              0x000017F4 /* in case a bootstrap routine needs a stack in local ram. Use this boundary */

#define LR_PCI_INTERRUPT_ENABLE  0x000017F4
#define LR_HOST_INTERRUPT_STATUS 0x000017F8
#define LR_CPU_BRU_JUMP          0x000017FC /* `bootrom_ucos jump' (debug purpose) */

#define LR_ETH_MAC_LO            0x00001ce0 /* Ethernet MAC addr low 4 bytes */
#define LR_ETH_MAC_HI            0x00001ce4 /* Ethernet MAC addr high bytes */

#define LR_HMMAD                 0x00001cf4
#define LR_KEY_ZONE              0x00001D00 /* 0x200 bytes, up to 0x1F00 */
#define LR_YAMON_DIGITS          0x00001F00
#define LR_XPU_DUMP              0x00001F00 /* 0x80 bytes, up to 0x1F80 */

#define LR_VSYNC_PERIOD          0x00001FA0 /* 0x20 bytes, up to 0x1FC0 */

#define LR_RANDOM_SEED           0x00001FC8 /* 0x08 bytes, up to 0x1FD0 */
#define LR_LOCAL_DEBUG_PROBE     0x00001FD0 /* 0x20 bytes, up to 0x1FF0 */

#define LR_GNET_MAC              0x00001FF4
#define LR_ZBOOT_STAGE           0x00001FF8
#define LR_XPU_STAGE             0x00001FFC

#endif // __EMHWLIB_LRAM_H__
