/*
 * include/asm-arm/arch-em86xx/irqs.h
 *
 * Copyright 2002-2004, Sigma Designs Inc.
 *
 * by Ho Lee 01/28/2003
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

#include <asm/arch/board/irqs.h>

/*
 *  IRQ 
 */

#define IRQ_SOFTINT                     0   // Software interrupt
#define IRQ_UART0                       1   // UART 1
#define IRQ_UART1                       2   // UART 2
#define IRQ_TIMER0                      5   // Timer 0
#define IRQ_TIMER1                      6   // Timer 1
#define IRQ_TIMER2                      7   // Reserved for Timer 2
#define IRQ_MBUS_W0                     9   // Host interface MBUS W0 channel
#define IRQ_MBUS_W1                     10  // Host interface MBUS W1 channel
#define IRQ_MBUS_R0                     11  // Host interface MBUS R0 channel
#define IRQ_MBUS_R1                     12  // Host interface MBUS R1 channel
#define IRQ_GPIO0                       13  // GPIO Interrupt #0
#define IRQ_GPIO1                       14  // GPIO Interrupt #1
#define IRQ_GPIO2                       15  // GPIO Interrupt #2
#define IRQ_GPIO3                       16  // GPIO Interrupt #3
#define IRQ_PCILOCALBUSFAULT            20  // PCI Local Bus Fault
#define IRQ_EXTERNAL                    21  // Reserved for External interrupt

#ifdef CONFIG_ARCH_MAMBO
#define IRQ_KEYBOARD                    3   // Reserved for keyboard
#define IRQ_MOUSE                       4   // Reserved for mouse
#define IRQ_RTC                         8   // Real Time Clock
#define IRQ_GRAPHICACCEL                25  // Graphic accelerator
#define IRQ_VSYNC0                      26  // VSYNC 0
#define IRQ_VSYNC1                      27  // VSYNC 1
#define IRQ_VSYNC2                      28  // VSYNC 2
#define IRQ_VSYNC3                      29  // VSYNC 3
#define IRQ_VSYNC4                      30  // VSYNC 4
#define IRQ_VSYNC5                      31  // VSYNC 5
#elif defined(CONFIG_ARCH_TANGO10)
#define IRQ_KEYBOARD                    3   // Reserved for keyboard
#define IRQ_RTC                         8   // Real Time Clock
#elif defined(CONFIG_ARCH_TANGO15)
#define IRQ_SMARTCARD                   3   // Smart Card
#define IRQ_ETHERNET                    8   // Ethernet
#endif

#ifdef CONFIG_ARCH_TANGO
#define IRQ_SERIALFLASH                 4   // Serial flash interrupt
#define IRQ_DVD                         7   // IDE DVD
#define IRQ_IDECTRL_IDEDMA              17  // IDE DMA
#define IRQ_IDECTRL_IDE                 18  // IDE PIO
#define IRQ_FRONTPANEL                  19  // Frontpanel
#define IRQ_I2C                         22  // IIC
#define IRQ_GRAPHICACCEL                23  // Graphic accelerator
#define IRQ_VSYNC0                      24  // VSYNC 0 (composite analog output)
#define IRQ_VSYNC1                      25  // VSYNC 1 (component analog output)
#define IRQ_VSYNC2                      26  // VSYNC 2 (main analog output)
#define IRQ_VSYNC3                      27  // VSYNC 3 (digital output)
#define IRQ_VSYNC4                      28  // VSYNC 4 (graphic input)
#define IRQ_VSYNC5                      29  // VSYNC 5 (graphic input)
#define IRQ_VSYNC6                      30  // VSYNC 6 (video input)
#define IRQ_VSYNC7                      31  // VSYNC 7 (video input)
#endif

#if defined(CONFIG_ARCH_TANGO15) && (CONFIG_ARCH_TANGO15_REV > 1)
#define IRQ_GPIO_PIN0                   48  // GPIO pin 0
#define IRQ_GPIO_PIN1                   49  // GPIO pin 1
#define IRQ_GPIO_PIN2                   50  // GPIO pin 2
#define IRQ_GPIO_PIN3                   51  // GPIO pin 3
#define IRQ_GPIO_PIN4                   52  // GPIO pin 4
#define IRQ_GPIO_PIN5                   53  // GPIO pin 5
#define IRQ_GPIO_PIN6                   54  // GPIO pin 6
#define IRQ_GPIO_PIN7                   55  // GPIO pin 7
#define IRQ_GPIO_PIN8                   56  // GPIO pin 8
#define IRQ_GPIO_PIN9                   57  // GPIO pin 9
#define IRQ_GPIO_PIN10                  58  // GPIO pin 10
#define IRQ_GPIO_PIN11                  59  // GPIO pin 11
#define IRQ_GPIO_PIN12                  60  // GPIO pin 12
#define IRQ_GPIO_PIN13                  61  // GPIO pin 13
#define IRQ_GPIO_PIN14                  62  // GPIO pin 12
#define IRQ_GPIO_PIN15                  63  // GPIO pin 15
#endif

#if defined(CONFIG_ARCH_TANGO15) && (CONFIG_ARCH_TANGO15_REV > 1)
#define NR_IRQS                         64
#else
#define NR_IRQS                         32
#endif

/*
 *  IRQ Masks
 */

#ifdef CONFIG_ARCH_MAMBO
#define IRQMASK_VALID                   (0xfe301fff | BOARDIRQMASK_VALID)
                                        // 1111 1110 0011 000- ---1 1111 1111 1111
#define IRQMASK_RISINGEDGE              (0xfc200a00 | BOARDIRQMASK_RISINGEDGE)  
                                        // 1111 1100 0010 000- ---0 1010 0000 0000
#define IRQMASK_FALLINGEDGE             (0x00000000 | BOARDIRQMASK_FALLINGEDGE)
                                        // 0000 0000 0000 000- ---0 0000 0000 0000
#define IRQMASK_LOWLEVEL                (0x00000000 | BOARDIRQMASK_LOWLEVEL)
                                        // 0000 0000 0000 000- ---0 0000 0000 0000
#define IRQMASK_EXTERNALIRQS            0x0021e000
                                        // 0000 0000 0010 0001 1110 0000 0000 0000
                                        // IRQ_GPIO[0..3], IRQ_EXTERNAL
#endif

#ifdef CONFIG_ARCH_TANGO10
#define IRQMASK_VALID                   (0xfffe1fff | BOARDIRQMASK_VALID)
                                        // 1111 1111 1111 111- ---1 1111 1111 1111
#define IRQMASK_RISINGEDGE              (0xff280a00 | BOARDIRQMASK_RISINGEDGE)  
                                        // 1111 1111 0010 100- ---0 1010 0000 0000
#define IRQMASK_FALLINGEDGE             (0x00000000 | BOARDIRQMASK_FALLINGEDGE)
                                        // 0000 0000 0000 000- ---0 0000 0000 0000
#define IRQMASK_LOWLEVEL                (0x00000000 | BOARDIRQMASK_LOWLEVEL)
                                        // 0000 0000 0000 000- ---0 0000 0000 0000
#define IRQMASK_EXTERNALIRQS            0x0029e000
                                        // 0000 0000 0010 1001 1110 0000 0000 0000
                                        // IRQ_GPIO[0..3], IRQ_EXTERNAL, IRQ_FRONTPANEL
#endif

#ifdef CONFIG_ARCH_TANGO15
#if (CONFIG_ARCH_TANGO15_REV > 1) /* Tango15 RevB or above */
#define IRQMASK_VALID                   ((u64)0x00000000fffe1fff | BOARDIRQMASK_VALID)
                                        // ---- ---- ---- ---- 0000 0000 0000 0000 - high 32
                                        // 1111 1111 1111 111- ---1 1111 1111 1111 - low 32
#define IRQMASK_RISINGEDGE              ((u64)0x00000000ff280b00 | BOARDIRQMASK_RISINGEDGE)  
                                        // ---- ---- ---- ---- 0000 0000 0000 0000 - high 32
                                        // 1111 1111 0010 100- ---0 1010 0000 0000 - low 32
#define IRQMASK_FALLINGEDGE             ((u64)0x0000000000000000 | BOARDIRQMASK_FALLINGEDGE)
                                        // ---- ---- ---- ---- 0000 0000 0000 0000 - high 32
                                        // 0000 0000 0000 000- ---0 0000 0000 0000 - low 32
#define IRQMASK_LOWLEVEL                ((u64)0x0000000000000000 | BOARDIRQMASK_LOWLEVEL)
                                        // ---- ---- ---- ---- 0000 0000 0000 0000 - high 32
                                        // 0000 0000 0000 000- ---0 0000 0000 0000 - low 32
#define IRQMASK_EXTERNALIRQS            (u64)0xffff00000029e100
                                        // 1111 1111 1111 1111 0000 0000 0000 0000 - high 32
                                        // 0000 0000 0010 1001 1110 0000 0000 0000 - low 32
                                        // IRQ_GPIO[0..3], IRQ_EXTERNAL, IRQ_FRONTPANEL, IRQ_ETHERNET
					// IRQ_GPIO_PIN0-15
#else
#define IRQMASK_VALID                   (0xfffe1fff | BOARDIRQMASK_VALID)
                                        // 1111 1111 1111 111- ---1 1111 1111 1111
#define IRQMASK_RISINGEDGE              (0xff280b00 | BOARDIRQMASK_RISINGEDGE)  
                                        // 1111 1111 0010 100- ---0 1010 0000 0000
#define IRQMASK_FALLINGEDGE             (0x00000000 | BOARDIRQMASK_FALLINGEDGE)
                                        // 0000 0000 0000 000- ---0 0000 0000 0000
#define IRQMASK_LOWLEVEL                (0x00000000 | BOARDIRQMASK_LOWLEVEL)
                                        // 0000 0000 0000 000- ---0 0000 0000 0000
#define IRQMASK_EXTERNALIRQS            0x0029e100
                                        // 0000 0000 0010 1001 1110 0000 0000 0000
                                        // IRQ_GPIO[0..3], IRQ_EXTERNAL, IRQ_FRONTPANEL, IRQ_ETHERNET
#endif
#endif

#if defined(CONFIG_ARCH_TANGO15) && (CONFIG_ARCH_TANGO15_REV > 1)
#define IRQMASKOF(x)                    (((u64)1) << (x))
#else
#define IRQMASKOF(x)                    (1 << (x))
#endif

#define IRQMASK_SOFTINT                 IRQMASKOF(IRQ_SOFTINT)
#define IRQMASK_UART0                   IRQMASKOF(IRQ_UART0)
#define IRQMASK_UART1                   IRQMASKOF(IRQ_UART1)
#define IRQMASK_TIMER0                  IRQMASKOF(IRQ_TIMER0)
#define IRQMASK_TIMER1                  IRQMASKOF(IRQ_TIMER1)
#define IRQMASK_TIMER2                  IRQMASKOF(IRQ_TIMER2)
#define IRQMASK_MBUS_W0                 IRQMASKOF(IRQ_MBUS_W0)
#define IRQMASK_MBUS_W1                 IRQMASKOF(IRQ_MBUS_W1)
#define IRQMASK_MBUS_R0                 IRQMASKOF(IRQ_MBUS_R0)
#define IRQMASK_MBUS_R1                 IRQMASKOF(IRQ_MBUS_R1)
#define IRQMASK_GPIO0                   IRQMASKOF(IRQ_GPIO0)
#define IRQMASK_GPIO1                   IRQMASKOF(IRQ_GPIO1)
#define IRQMASK_GPIO2                   IRQMASKOF(IRQ_GPIO2)
#define IRQMASK_GPIO3                   IRQMASKOF(IRQ_GPIO3)
#define IRQMASK_PCILOCALBUSFAULT        IRQMASKOF(IRQ_PCILOCALBUSFAULT)
#define IRQMASK_EXTERNAL                IRQMASKOF(IRQ_EXTERNAL)

#define IRQMASK_VSYNC0                  IRQMASKOF(IRQ_VSYNC0)
#define IRQMASK_VSYNC1                  IRQMASKOF(IRQ_VSYNC1)
#define IRQMASK_VSYNC2                  IRQMASKOF(IRQ_VSYNC2)
#define IRQMASK_VSYNC3                  IRQMASKOF(IRQ_VSYNC3)
#define IRQMASK_VSYNC4                  IRQMASKOF(IRQ_VSYNC4)
#define IRQMASK_VSYNC5                  IRQMASKOF(IRQ_VSYNC5)

#ifdef CONFIG_ARCH_MAMBO
#define IRQMASK_KEYBOARD                IRQMASKOF(IRQ_KEYBOARD)
#define IRQMASK_MOUSE                   IRQMASKOF(IRQ_MOUSE)
#define IRQMASK_RTC                     IRQMASKOF(IRQ_RTC)
#define IRQMASK_GRAPHICACCEL            IRQMASKOF(IRQ_GRAPHICACCEL)
#elif defined(CONFIG_ARCH_TANGO10)
#define IRQMASK_KEYBOARD                IRQMASKOF(IRQ_KEYBOARD)
#define IRQMASK_RTC                     IRQMASKOF(IRQ_RTC)
#elif defined(CONFIG_ARCH_TANGO15)
#define IRQMASK_SMARTCARD               IRQMASKOF(IRQ_SMARTCARD)
#define IRQMASK_ETHERNET                IRQMASKOF(IRQ_ETHERNET)
#endif

#ifdef CONFIG_ARCH_TANGO
#define IRQMASK_SERIALFLASH             IRQMASKOF(IRQ_SERIALFLASH)
#define IRQMASK_DVD                     IRQMASKOF(IRQ_DVD)
#define IRQMASK_IDECTRL_IDEDMA          IRQMASKOF(IRQ_IDECTRL_IDEDMA)
#define IRQMASK_IDECTRL_IDE             IRQMASKOF(IRQ_IDECTRL_IDE)
#define IRQMASK_FRONTPANEL              IRQMASKOF(IRQ_FRONTPANEL)
#define IRQMASK_I2C                     IRQMASKOF(IRQ_I2C)
#define IRQMASK_GRAPHICACCEL            IRQMASKOF(IRQ_GRAPHICACCEL)
#define IRQMASK_VSYNC6                  IRQMASKOF(IRQ_VSYNC6)
#define IRQMASK_VSYNC7                  IRQMASKOF(IRQ_VSYNC7)
#endif

#if defined(CONFIG_ARCH_TANGO15) && (CONFIG_ARCH_TANGO15_REV > 1)
#define IRQMASK_GPIO_PIN0               IRQMASKOF(IRQ_GPIO_PIN0)
#define IRQMASK_GPIO_PIN1               IRQMASKOF(IRQ_GPIO_PIN1)
#define IRQMASK_GPIO_PIN2               IRQMASKOF(IRQ_GPIO_PIN2)
#define IRQMASK_GPIO_PIN3               IRQMASKOF(IRQ_GPIO_PIN3)
#define IRQMASK_GPIO_PIN4               IRQMASKOF(IRQ_GPIO_PIN4)
#define IRQMASK_GPIO_PIN5               IRQMASKOF(IRQ_GPIO_PIN5)
#define IRQMASK_GPIO_PIN6               IRQMASKOF(IRQ_GPIO_PIN6)
#define IRQMASK_GPIO_PIN7               IRQMASKOF(IRQ_GPIO_PIN7)
#define IRQMASK_GPIO_PIN8               IRQMASKOF(IRQ_GPIO_PIN8)
#define IRQMASK_GPIO_PIN9               IRQMASKOF(IRQ_GPIO_PIN9)
#define IRQMASK_GPIO_PIN10              IRQMASKOF(IRQ_GPIO_PIN10)
#define IRQMASK_GPIO_PIN11              IRQMASKOF(IRQ_GPIO_PIN11)
#define IRQMASK_GPIO_PIN12              IRQMASKOF(IRQ_GPIO_PIN12)
#define IRQMASK_GPIO_PIN13              IRQMASKOF(IRQ_GPIO_PIN13)
#define IRQMASK_GPIO_PIN14              IRQMASKOF(IRQ_GPIO_PIN14)
#define IRQMASK_GPIO_PIN15              IRQMASKOF(IRQ_GPIO_PIN15)
#endif

/*
 * FIQ & FIQ Masks
 *
 * use same defintions with IRQs
 */

#if defined(CONFIG_ARCH_TANGO15) && (CONFIG_ARCH_TANGO15_REV > 1)
#define NR_FIQS                         64
#else
#define NR_FIQS                         32
#endif

/*
 * Soft IRQ
 */

// MSB 4 bits are assigned to kernel
#define SOFTIRQ_IDE                     15

#define SOFTIRQMASK_VALID               0xf010

#define NR_SOFTIRQS                     16

#endif
