/*
 * include/asm-arm/arch-em86xx/memory.h
 *
 * Copyright 2002-2004, Sigma Designs, Inc 
 */

#ifndef __ASM_ARCH_MEMORY_H
#define __ASM_ARCH_MEMORY_H

#include <asm/arch/memcfg.h>

extern memcfg_t *em86xx_memcfg_ptr;
extern unsigned long em86xx_kmemsize;

#define TASK_SIZE       (em86xx_kmemsize + 0x40000)
#define TASK_SIZE_26    TASK_SIZE

#define PAGE_OFFSET     PHYS_OFFSET
#define END_MEM         (DRAM_BASE + em86xx_kmemsize)

#define PHYS_OFFSET     (DRAM_BASE)
#define MEM_SIZE        (em86xx_kmemsize)

// by Ho Lee 10/14/2003
// __virt_to_bus() function is only used by request_standard_resources() in 
// arch/armnommu/kernel/setup.c
// __bus_to_virt() function is not used
// I don't know why this function is needed
#define __virt_to_bus(x)    (x)
#define __bus_to_virt(x)    (x)

#define __virt_to_phys(x)   virt_to_phys(x)
#define __phys_to_virt(x)   phys_to_virt(x)

#include <asm/hardware.h>
#define em86xx_to_ncaddr(x) (EM86XX_DRAM_C2NC(x))
#define em86xx_to_caddr(x) (EM86XX_DRAM_NC2C(x))

#ifdef CONFIG_SD_EM86XX_PCIDMA

extern unsigned int g_pcimem_busaddr, g_pcimem_phyaddr, g_pcimem_phyaddr_end;

#define is_virt_dmable(x)	(((em86xx_to_ncaddr(x)) >= g_pcimem_phyaddr \
			&& (em86xx_to_ncaddr(x)) < g_pcimem_phyaddr_end) \
			? 1 : 0)
#define is_bus_dmable(x)	(is_virt_dmable((unsigned long) bus_to_virt(x)))

#define virt_to_bus(x)		(((em86xx_to_ncaddr((unsigned long) (x)) - g_pcimem_phyaddr + g_pcimem_busaddr)))
#define bus_to_virt(x)		((void *) ((unsigned long) (x) + g_pcimem_phyaddr - g_pcimem_busaddr))
#endif

#ifdef CONFIG_DISCONTIGMEM
/*
 * by Ho Lee 11/18/2003
 *
 * EM86xx supports up to three DRAM controllers, and now two of them are used.
 * There is wide memory address space between two physical RAM banks, and it's
 * necessary to use NUMA supports to make use of all the memory. All the nodes
 * have equal access characteristics.
 *
 * node 0 : PAGE_OFFSET - em86xx_kmemsize (MEMORY_BASE_DRAMCTRL0)
 * node 1 : DRAM_BASE_2 - em86xx_memcfg_ptr->dram1_size (MEMORY_BASE_DRAMCTRL1)
 * node 2 : DRAM_BASE_2 - em86xx_memcfg_ptr->dram2_size (MEMORY_BASE_DRAMCTRL2)
 *
 * Refer to other implemenation of 'noncontinuous memory bank', e.g. arch-sa1100
 */

/* maximum number of nodes. For compatability with other architecture, 
 * set NR_NODES to 4
 */
#define NR_NODES    4

/*
 * Given a kernel address, find the home node of the underlying memory.
 * MSB 4 bits of address decides the node address
 */
#define KVADDR_TO_NID(addr) (((unsigned long)(addr) - (PAGE_OFFSET & 0xf0000000)) >> 28)

/*
 * Given a page frame number, convert it to a node id.
 * MSB 4 bits of address decides the node address
 * Not implemented, not used
 */
// #define PFN_TO_NID(pfn)      (((pfn) - PHYS_PFN_OFFSET) >> (28 - PAGE_SHIFT))

/*
 * Given a kaddr, ADDR_TO_MAPBASE finds the owning node of the memory
 * and returns the mem_map of that node.
 */
#define ADDR_TO_MAPBASE(kaddr)  NODE_MEM_MAP(KVADDR_TO_NID(kaddr))

/*
 * Given a page frame number, find the owning node of the memory
 * and returns the mem_map of that node.
 * Not implemented, not used
 */
// #define PFN_TO_MAPBASE(pfn)      NODE_MEM_MAP(PFN_TO_NID(pfn))

/*
 * Given a kaddr, LOCAL_MEM_MAP finds the owning node of the memory
 * and returns the index corresponding to the appropriate page in the
 * node's mem_map. Find start address of each node from pg_data_t 
 * data structure. 
 */
#define LOCAL_MAP_NR(addr)      ((((unsigned long) (addr)) - NODE_DATA(KVADDR_TO_NID(addr))->node_start_paddr) >> PAGE_SHIFT)

#endif

#endif

