#ifndef __ASM_ARM_IRQ_H
#define __ASM_ARM_IRQ_H

#include <asm/arch/irqs.h>

#ifndef irq_cannonicalize
#define irq_cannonicalize(i)	(i)
#endif

#ifndef NR_IRQS
#define NR_IRQS	128
#endif

/*
 * Use this value to indicate lack of interrupt
 * capability
 */
#ifndef NO_IRQ
#define NO_IRQ	((unsigned int)(-1))
#endif

#define disable_irq_nosync(i) disable_irq(i)

extern void disable_irq(unsigned int);
extern void enable_irq(unsigned int);

#ifdef CONFIG_SD_EM86XX
int em86xx_check_lost_irq(unsigned int irq);
#endif

#ifdef CONFIG_SD_FIQ
typedef void (*fiq_handler_t)(int fiq, void *dev_id);
int request_fiq(unsigned int fiq, fiq_handler_t handler, const char *devname, void *dev_id);
int free_fiq(unsigned int fiq);
void mask_fiq(unsigned int fiq);
void unmask_fiq(unsigned int fiq);
#endif

#endif

