
#include <stdio.h>
#include <unistd.h>
#include <sys/file.h>

#define _PATH_DEVNULL "/dev/null"
int daemon( int nochdir, int noclose )
{
	int fd;

	switch (vfork()) {
		case -1:
			return(-1);
		case 0:
			break;
		default:
			_exit(0);
	}

	if (setsid() == -1)
		return(-1);

	/* Make certain we are not a session leader, or else we
	 * might reacquire a controlling terminal */
	if (vfork())
		_exit(0);

	if (!nochdir)
		chdir("/");

	if (!noclose && (fd = open(_PATH_DEVNULL, O_RDWR, 0)) != -1) {
		dup2(fd, STDIN_FILENO);
		dup2(fd, STDOUT_FILENO);
		dup2(fd, STDERR_FILENO);
		if (fd > 2)
			close(fd);
	}
	return(0);
}
