/*
 * include/asm-arm/arch-em86xx/ide.h:
 *
 * Copyright 2002-2004, Sigma Designs, Inc 
 *
 * by Ho Lee
*/

/*
    Legacy ISA based IDE controllers have two kinds of registers.

    1. Command Block Register
        0x00 : Data => io_ports[IDE_DATA_OFFSET]
        0x01 : Error/Features => io_ports[IDE_ERROR_OFFSET]
        0x02 : Sector count => io_ports[IDE_NSECTOR_OFFSET]
        0x03 : Sector number => io_ports[IDE_SECTOR_OFFSET]
        0x04 : Cylinder low => io_ports[IDE_LCYL_OFFSET]
        0x05 : Cylinder high => io_ports[IDE_HCYL_OFFSET]
        0x06 : Drive/Head => io_ports[IDE_iSELECT_OFFSET]
        0x07 : Status/Command => io_ports[IDE_STATUS_OFFSET]
    2. Control Block Register
        0x00 : Control => io_ports[IDE_CONTROL_OFFSET]

    Legacy IDE controllers have these register in the I/O space

                    Command             Control
        Primary     0x1f0 - 0x1f7       0x3f6
        Secondary   0x170 - 0x177       0x376

    Recent PCI based IDE controllers have these registers and another
    register for bus mastering. They are mapped into the PCI I/O address space,
    and 16 bytes long. Usually they are : 

        BMICX P/S : Bus Master IDE command register (2 bytes)
        BMISX P/S : Bus Master IDE status register (2 bytes)
        BMIDTPX P/S : Bus Master IDE Descriptor Table Pointer Register (4 bytes)

    Also PCI based IDE controllers have some timing registers. Usually they
    are mapped into the PCI configuration area. 
        
        IDETIM P/S : IDE timing register (2 bytes)
        SIDETIM : Slave IDE timing register

    Some IDE controllers also supports UDMA. They have more reigsers, which are
    usually mapped into the PCI configuration area.

        UDMACTL : Ultra DMA control register
        UDMATIM : Ultra DMA timing register

    ----------------------------------------------------------------------------

    EM86XX IDE controller has only one kind of IDE register

        Command Block Register : 0x20000 - 0x2001c

    EM86XX IDE controller doesn't have Bus Mastering functionality, but we can
    make use of MBUS DMA for that. 
*/

#ifndef __ASM_ARCH_IDE_H
#define __ASM_ARCH_IDE_H

#include <linux/config.h>
#include <asm/irq.h>
#include <asm/hardware.h>

#if defined(CONFIG_BLK_DEV_EM86XX_ISAIDE) || defined(CONFIG_BLK_DEV_EM86XX_BMIDE)
#ifdef MAX_HWIFS
#undef MAX_HWIFS
#endif

#define MAX_HWIFS               2
#endif

//
// Initialize IDE
//

void ide_init_hwif_ports(hw_regs_t *hw, ide_ioreg_t data_port, ide_ioreg_t ctrl_port, int *irq);
void ide_init_default_hwifs(void);

// 
// by Ho Lee
//

#if defined(CONFIG_SD_IDE_FASTPROBE) || defined(CONFIG_BLK_DEV_EM86XX_PBIDENOIRQ)
struct hwif_s;
int ide_wait_stat_sd(struct hwif_s *hwif, int reg, int mask, int waitmask, int usetimeout);
#endif

#endif
