
/* This file defines the memory map structure to be used */

#ifndef __MEMCFG_H__
#define __MEMCFG_H__

#include "emhwlib_dram.h"

#ifndef __ASSEMBLY__

/* The start address for the memory configurtion data */
#define MEMCFG_START            (0x10000000 + FM_MEMCFG)

static inline int is_valid_memcfg(memcfg_t *memcfg_ptr)
{
    unsigned int sum, i, *ptr;

    if ((memcfg_ptr->signature) != MEMCFG_SIGNATURE)
	return(0);
    for (sum = i = 0, ptr = (unsigned int *)memcfg_ptr; 
	i < (sizeof(memcfg_t) / sizeof(unsigned int)); i++, ptr++)
	sum += (*ptr);
    return((sum == 0) ? 1 : 0);
}

static inline void gen_memcfg_checksum(memcfg_t *memcfg_ptr)
{
    unsigned int sum, i, *ptr;

    memcfg_ptr->checksum = 0;
    for (sum = i = 0, ptr = (unsigned int *)memcfg_ptr; 
	i < (sizeof(memcfg_t) / sizeof(unsigned int)); i++, ptr++)
	sum += (*ptr);
    memcfg_ptr->checksum = ~sum + 1;
}

#endif /* __ASSEMBLY__ */
#endif /* __MEMCFG_H__ */

