/*
 * include/asm-arm/arch-em86xx/time.h
 *
 * Copyright 2002-2004, Sigma Designs, Inc
 *
 * by Ho Lee 01/27/2003
 */

#ifndef __ASM_ARCH_TIME_H
#define __ASM_ARCH_TIME_H

#include <asm/arch/hardware.h>

// CPU_timer0_load
//   clock / HZ / (2 * prescale)
// CPU_timer0_ctrl
//   PS(D2-3) : prescale. 0x00 = 1, 0x01 = 16, 0x10 = 256
//     There is a bug, and the actual prescale is 0x01 = 32, 0x10 = 512
//   M(D6) : periodic mode
//   E(D7) : enable

#define TICKS_PER_SEC           __get_clock(2)
#define TIMER_PRESCALE          512 
#define TIMER_PRESCALEBITS      9
#define TIMER_RELOAD            ((TICKS_PER_SEC / HZ) >> (TIMER_PRESCALEBITS))

#define TIMER_ENABLE            0x80    // D7
#define TIMER_PERIODIC          0x40    // D6
#define TIMER_PRESCALE_1        0x00    // D[2-3] = 00b
#define TIMER_PRESCALE_32       0x04    // D[2-3] = 01b
#define TIMER_PRESCALE_512      0x08    // D[2-3] = 10b

extern struct irqaction timer_irq;
extern void em86xx_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs);

__inline__ void setup_timer(void)
{
    // CPU_timer0_load register contains just 16-bits value
    // So, take cate not the value to overflow
    __raw_writel(TIMER_RELOAD, REG_BASE_CPU + CPU_timer0_load);
    __raw_writel(TIMER_ENABLE | TIMER_PERIODIC | TIMER_PRESCALE_512, REG_BASE_CPU + CPU_timer0_ctrl);
    __raw_writel(1, REG_BASE_CPU + CPU_timer0_clr);

    timer_irq.handler = em86xx_timer_interrupt;
    setup_arm_irq(IRQ_TIMER0, &timer_irq);
}

#endif
