/*
 * include/asm-arm/arch-em86xx/board-generic/irqs.h
 *
 * Copyright (C) 2003-2004 Sigma Designs, Inc
 * 
 * Sigma Designs Evaluation Boards
 */

#ifndef __ASM_ARCH_BOARD_IRQS_H
#define __ASM_ARCH_BOARD_IRQS_H

#include <asm/arch/boardname.h>

// GPIO 6 - IRQ_GPIO0 - IDE_INT (active high)
// GPIO 9 - IRQ_GPIO1 - PCI_INT_A / PCI_INT_B / PCI_INT_C / PCI_INT_D (active low)
// GPIO 9 - IRQ_GPIO1 - PCIFPGA_INT (active high)

// edge detector configuration
#define BOARDIRQMASK_VALID              0x0001e000  // ---- ---- ---- ---1 111- ---- ---- ----
#define BOARDIRQMASK_RISINGEDGE         0x00000000  // ---- ---- ---- ---0 000- ---- ---- ----
#ifdef CONFIG_PCI_EM86XX_HOST_FPGA
#define BOARDIRQMASK_FALLINGEDGE        0x00018000  // ---- ---- ---- ---1 100- ---- ---- ----
#define BOARDIRQMASK_LOWLEVEL           0x00000000  // ---- ---- ---- ---0 000- ---- ---- ----
#else
#define BOARDIRQMASK_FALLINGEDGE        0x0001c000  // ---- ---- ---- ---1 110- ---- ---- ----
#define BOARDIRQMASK_LOWLEVEL           0x00004000  // ---- ---- ---- ---0 010- ---- ---- ----
#endif

// board specific interrupts
#define IRQ_IDE                         IRQ_GPIO0
#define IRQ_PCIFPGA                     IRQ_GPIO1

#define SOFTIRQ_PCIFPGA                 14

// PCI interrupt mapping
#define PCI_IRQ_MAP(idsel, irqpin)      IRQ_GPIO1

#endif

