/*
 *  linux/include/asm-arm/memory.h
 *
 *  Copyright (C) 2000 Russell King
 *  Copyright (C) 2001 RidgeRun, Inc (http://www.ridgerun.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  Note: this file should not be included by non-asm/.h files
 *
 *  Modifications:
 *  02/20/01  Gordon McNutt  Leveraged for uClinux-2.4.x
 */
#ifndef __ASM_ARM_MEMORY_H
#define __ASM_ARM_MEMORY_H

#include <asm/arch/memory.h>

/*
 * Virtual, bus and physical addresses are all the same when there's no MMU.
 * --gmcnutt
 */
#ifndef virt_to_bus
#define virt_to_bus(x) ((unsigned long) (x))
#endif
#ifndef bus_to_virt
#define bus_to_virt(x) ((void *) (x))
#endif
#define virt_to_phys(x) ((unsigned long) (x))
#define phys_to_virt(x) ((void *) (x))

#if 0
/*
 * For some reason other asm/.h files refer to these instead of the more 
 * public macros above.
 * --gmcnutt
 */
#define __virt_to_bus(x) ((unsigned long) (x))
#define __bus_to_virt(x) ((void *) (x))
#define __virt_to_phys(x) ((unsigned long) (x))
#define __phys_to_virt(x) ((void *) (x))
#endif

/*
 * Conversion between a struct page and a physical address.
 *
 * Note: when converting an unknown physical address to a
 * struct page, the resulting pointer must be validated
 * using VALID_PAGE().  It must return an invalid struct page
 * for any physical address not corresponding to a system
 * RAM address.
 *
 *  page_to_pfn(page)  convert a struct page * to a PFN number
 *  pfn_to_page(pfn)   convert a _valid_ PFN number to struct page *
 *  pfn_valid(pfn)     indicates whether a PFN number is valid
 *
 *  page_to_phys(page) convert a struct page * to physical address
 *
 *  Refer to asm-arm/memory.h
 */
#ifndef CONFIG_DISCONTIGMEM
#define __page_address(page)	(PAGE_OFFSET + (((page) - mem_map) << PAGE_SHIFT))
#define page_to_phys(page)	virt_to_phys((void *)__page_address(page))
#else
#define page_to_pfn(page)					\
	(((page) - page_zone(page)->zone_mem_map)		\
	  + (page_zone(page)->zone_start_paddr >> PAGE_SHIFT))

#define pfn_to_page(pfn)					\
	(PFN_TO_MAPBASE(pfn) + LOCAL_MAP_NR((pfn) << PAGE_SHIFT))

#define pfn_valid(pfn)						\
  ({								\
	unsigned int node = PFN_TO_NID(pfn);			\
	struct pglist_data *nd = NODE_DATA(node);		\
	((node < NR_NODES) &&					\
	 ((pfn - (nd->node_start_paddr >> PAGE_SHIFT)) < nd->node_size));\
   })

#define page_to_phys(page)	(page_to_pfn(page) << PAGE_SHIFT)
#endif

/*
 * arch/armnommu/kernel/armksyms.c needs these.
 * --gmcnutt
 */
#define __virt_to_phys__is_a_macro
#define __phys_to_virt__is_a_macro
#define __virt_to_bus__is_a_macro
#define __bus_to_virt__is_a_macro

#endif
