/* 
 * Copyright 2003 Sony Corporation
 */

#ifndef _LFX_LIVE_MEDIA_CONFIG_HH
#define _LFX_LIVE_MEDIA_CONFIG_HH

#define LFXSC_RESPONSE_BUFFER_SIZE    5000
#define LFXSC_DESCRIBE_BUFFER_SIZE    7000

#define LFXSCCFG_RECURSION_DEPTH        16

#define LFXSCCFG_REODERING_QUEUE_SIZE  128
#define LFXSCCFG_RESPONSE_TIMEOUT_SEC   30

#ifdef  LFXSCCFG_USE_LFX_SEND

#define WAIT_FOREVER -1

extern "C" int lfxsend(int s, const char* buf, int bufLen, int flags, int timeoutSec=WAIT_FOREVER);
extern "C" int lfxrecv(int s, const char* buf, int bufLen, int flags, int timeoutSec=WAIT_FOREVER);
extern "C" int lfxRegisterSocket(int aSocket);
extern "C" int lfxUnregisterSocket(int aSocket);
extern "C" int lfxAbortTaskOnSocket(int aSocket);
#define send lfxsend
#define recv lfxrecv
//
// live.com uses recvfrom to read from and sendto to write to its sockets 
// regardless of them being datagram or tcp sockets. bluntly redefining 
// recvfrom as lfxrecv for sure breaks udp streaming on vxworks.
// 
#define recvfrom(s,b,l,f,x,y)  lfxrecv(s,b,l,f)
#define sendto(s,b,l,f,x,y)    lfxsend(s,b,l,f)
#else

#define lfxRegisterSocket(s)
#define lfxUnregisterSocket(s)
#define lfxAbortTaskOnSocket(s)

#endif

#endif /* _LFX_LIVE_MEDIA_CONFIG_HH */
