/**********
 SONY:
 This file implements a function to compute the response field of a 
 HTTP digest authentication request. It is duplicated from the function 
 defined in RTSPClient.cpp:

 static char* computeDigestResponse(AuthRecord const& authenticator,
	       			    char const* cmd, char const* url);

 It is duplicated to avoid pulling in the rest of the implementation 
 in the original file while linking it to server code.
 **********/

/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2002 Live Networks, Inc.  All rights reserved.
// A generic RTSP client
// Implementation

#include <stdio.h>
#include <string.h>

#if defined(__vxworks)
#include <LfxNew.h>
#endif

#include <strDup.hh>
#include <stdlib.h>

#include "our_md5.h"

//
// defined in live.com (and not included because it would pull in too much)
//
struct AuthRecord {
  char const* realm; char const* nonce;
  char const* username; char const* password;
};

char* 
doComputeDigestResponse(AuthRecord const& authenticator,
			char const* cmd, 
			char const* url) {

  // The "response" field is computed as:
  //    md5(md5(<username>:<realm>:<password>):<nonce>:md5(<cmd>:<url>))
  unsigned const ha1DataLen = strlen(authenticator.username) + 1
    + strlen(authenticator.realm) + 1 + strlen(authenticator.password);
  unsigned char* ha1Data = new unsigned char[ha1DataLen+1];
  sprintf((char*)ha1Data, "%s:%s:%s",
	  authenticator.username, authenticator.realm,
	  authenticator.password);
  char ha1Buf[33];
  our_MD5Data(ha1Data, ha1DataLen, ha1Buf);
  delete [] ha1Data;

  unsigned const ha2DataLen = strlen(cmd) + 1 + strlen(url);
  unsigned char* ha2Data = new unsigned char[ha2DataLen+1];
  sprintf((char*)ha2Data, "%s:%s", cmd, url);
  char ha2Buf[33];
  our_MD5Data(ha2Data, ha2DataLen, ha2Buf);
  delete [] ha2Data;

  unsigned const digestDataLen
    = 32 + 1 + strlen(authenticator.nonce) + 1 + 32;
  unsigned char* digestData = new unsigned char[digestDataLen+1];
  sprintf((char*)digestData, "%s:%s:%s",
	  ha1Buf, authenticator.nonce, ha2Buf);
  return our_MD5Data(digestData, digestDataLen, NULL);
}

char* 
doCreateAuthenticatorString(AuthRecord const* authenticator,
			    char const* cmd, char const* url)
{
  if (authenticator != NULL && authenticator->realm != NULL
      && authenticator->nonce != NULL && authenticator->username != NULL
      && authenticator->password != NULL) {

    // We've been provided a filled-in authenticator, so use it:
    char* const authFmt = "Authorization: Digest username=\"%s\", realm=\"%s\", nonce=\"%s\", uri=\"%s\", response=\"%s\"\r\n";
    char const* response = doComputeDigestResponse(*authenticator, cmd, url);
    unsigned authBufSize = strlen(authFmt)
      + strlen(authenticator->username) + strlen(authenticator->realm)
      + strlen(authenticator->nonce) + strlen(url) + strlen(response);
    char* authenticatorStr = new char[authBufSize];
    sprintf(authenticatorStr, authFmt,
	    authenticator->username, authenticator->realm,
	    authenticator->nonce, url, response);
    free((char*)response); // NOT delete, because it was malloc-allocated

    return authenticatorStr;
  }

  return strDup("");
}
