/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**********/

/**********

Was originally part of MPEGVideoStreamFramer.hh, taken out because it's
shared with MPEG4VideoStreamFramer.hh

**********/


/* original copyright statement: */

// "liveMedia"
// Copyright (c) 1996-2002 Live Networks, Inc.  All rights reserved.
// A filter that breaks up an MPEG 1 or 2 video elementary stream into
//   frames for: Video_Sequence_Header, GOP_Header, Picture_Header
// C++ header


#ifndef _TIMECODE_HH
#define _TIMECODE_HH


class TimeCode {
public:
  TimeCode();
  virtual ~TimeCode();

  int operator==(TimeCode const& arg2);
  int operator!=(TimeCode const& arg2);
  void incSeconds(unsigned a = 1) {
    seconds += a;
    if (seconds > 59) {
      seconds %= 60;
      incMinutes();
    }
  }
  void incMinutes(unsigned a = 1) {
    minutes += a;
    if (minutes > 59) {
      minutes %= 60;
      incHours();
    }
  }
  void incHours(unsigned a = 1) {
    hours += a;
    if (hours > 23) {
      hours %= 24;
      days++;
    }
  }  

  unsigned days, hours, minutes, seconds, pictures;
};

////////// TimeCode implementation //////////

inline
TimeCode::TimeCode()
  : days(0), hours(0), minutes(0), seconds(0), pictures(0) {
}

inline
TimeCode::~TimeCode() {
}

inline
int TimeCode::operator==(TimeCode const& arg2) {
  return pictures == arg2.pictures && seconds == arg2.seconds
    && minutes == arg2.minutes && hours == arg2.hours && days == arg2.days;
}

inline
int TimeCode::operator!=(TimeCode const& arg2) {
  return !(*this == arg2);
}


#endif 
