/*
 * Decompiled with CFR 0.152.
 */
package com.sony.dps.dpscreencast.common;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PacketBase {
    protected Document mDoc;
    protected Element mRootElement;
    protected static final String TAG_COMMAND = "command";
    protected static final String COMMAND_ATT_KEY_NAME = "name";

    public PacketBase(String data) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.mDoc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e1) {
            // empty catch block
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringReader sr = new StringReader(data);
            transformer.transform(new StreamSource(sr), new DOMResult(this.mDoc));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    protected PacketBase(String id, String name) {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.mDoc = docBuilder.newDocument();
            this.mRootElement = this.mDoc.createElement(TAG_COMMAND);
            this.mRootElement.setAttribute(COMMAND_ATT_KEY_NAME, name);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
    }

    public String getPacketClass() {
        NodeList list = this.mDoc.getElementsByTagName(TAG_COMMAND);
        Element elm = (Element)list.item(0);
        String name = elm.getAttribute(COMMAND_ATT_KEY_NAME);
        return name;
    }

    public Map<String, String> getAttributes(String tag) {
        return null;
    }

    public String getString() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(this.mDoc), new StreamResult(sw));
            return sw.toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }
}

