/*
 * Decompiled with CFR 0.152.
 */
package com.sony.dps.dpscreencast.viewer;

import com.sony.dps.dpscreencast.common.PacketBase;
import com.sony.dps.dpscreencast.common.PacketHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class DPController_CommandBase
extends Thread {
    protected int mDstPort = 54321;
    protected String mDstAddress = "10.0.0.1";
    protected Socket mSocket = null;
    protected OutputStream mOutputStream = null;
    protected InputStream mInputStream = null;

    protected void initalizeConnection() throws UnknownHostException, IOException {
        this.mSocket = new Socket();
        this.mSocket.setTcpNoDelay(true);
        this.mSocket.setSendBufferSize(8192);
        this.mSocket.connect(new InetSocketAddress(this.mDstPort));
        this.mOutputStream = this.mSocket.getOutputStream();
        this.mInputStream = this.mSocket.getInputStream();
    }

    protected void finalizeConnection() throws IOException {
        if (this.mInputStream != null) {
            this.mInputStream.close();
        }
        if (this.mOutputStream != null) {
            this.mOutputStream.close();
        }
        if (this.mSocket != null) {
            this.mSocket.close();
        }
    }

    protected void sendPacket(PacketBase packet) throws IOException {
        if (this.mOutputStream == null) {
            throw new IOException();
        }
        PrintWriter pw = new PrintWriter(this.mOutputStream, true);
        pw.println(packet.getString());
    }

    protected PacketBase receivePacket() throws IOException {
        PacketBase ret = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(this.mInputStream));
        String data = br.readLine();
        ret = PacketHelper.createPacketFromString(data);
        return ret;
    }

    protected void sendFile(File file) throws IOException {
        FileInputStream fileIn = new FileInputStream(file);
        DataOutputStream out = new DataOutputStream(this.mOutputStream);
        byte[] buff = new byte[8192];
        while (true) {
            int len = fileIn.read(buff);
            System.out.println("write:" + len);
            if (0 >= len) break;
            out.write(buff, 0, len);
        }
        fileIn.close();
    }

    protected void receiveFile(File file, int size) throws IOException {
        int oneSize;
        DataInputStream in = new DataInputStream(this.mInputStream);
        FileOutputStream fileOut = new FileOutputStream(file);
        byte[] buff = new byte[8192];
        for (int total = 0; total < size; total += oneSize) {
            oneSize = in.read(buff);
            if (0 >= oneSize) continue;
            fileOut.write(buff, 0, oneSize);
        }
        fileOut.close();
    }

    protected InputStream getInputStream() {
        return this.mInputStream;
    }

    public static interface ResultListener {
        public void onFinish(boolean var1);
    }
}

