/*
 * Decompiled with CFR 0.152.
 */
package com.sony.dps.dpscreencast.viewer;

import com.sony.dps.dpscreencast.common.PacketBase;
import com.sony.dps.dpscreencast.common.Packet_RETSCREENSYNC;
import com.sony.dps.dpscreencast.viewer.DPController_SockClient;
import com.sony.dps.dpscreencast.viewer.IUpdateRequest;
import com.sony.dps.dpscreencast.viewer.ServerSearcher;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class DPController_ScreenSync
extends Thread
implements ServerSearcher.OnFoundListener {
    private static final int INTERVAL_TIME = 2000;
    private boolean mIsPortlate = true;
    private IUpdateRequest mListener;
    private DPController_SockClient mClient = null;
    private ServerSearcher mServerSearcher;
    private SocketAddress mServerAddr;
    private long mStartTime;

    public DPController_ScreenSync(int width, int height, IUpdateRequest listener) {
        this.mListener = listener;
        this.mClient = new DPController_SockClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (this.mServerAddr == null) {
                System.out.println("Server not found");
                this.searchServer();
                try {
                    DPController_ScreenSync.sleep(2000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                this.mStartTime = System.currentTimeMillis();
                this.mClient.connectToServer(this.mServerAddr);
                PacketBase revPacket = this.mClient.receivePacket();
                if (revPacket instanceof Packet_RETSCREENSYNC) {
                    Packet_RETSCREENSYNC retScrSync = (Packet_RETSCREENSYNC)revPacket;
                    Map<String, String> confAttributes = retScrSync.getAttributes("conf");
                    this.mIsPortlate = confAttributes.get("orientation").equals("portrait");
                    Map<String, String> retAttributes = retScrSync.getAttributes("response");
                    if (retAttributes.get("ret").equals("ack")) {
                        this.mListener.doUpdate(this.mClient.getBufferImage());
                    }
                }
                this.stopSearchServer();
                continue;
            }
            catch (UnknownHostException e) {
                System.out.println("UnknownHostException:" + e.getMessage());
                this.mServerAddr = null;
                continue;
            }
            catch (IOException e) {
                System.out.println("IOException:" + e.getMessage());
                this.mServerAddr = null;
                continue;
            }
            finally {
                this.mClient.finalize();
                this.delay(2000L - (System.currentTimeMillis() - this.mStartTime));
                continue;
            }
            break;
        }
    }

    private void delay(long delayTime) {
        if (delayTime <= 0L) {
            return;
        }
        try {
            DPController_ScreenSync.sleep(delayTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isPortlate() {
        return this.mIsPortlate;
    }

    @Override
    public void onFound(SocketAddress addr) {
        this.mServerAddr = addr;
    }

    private void searchServer() {
        if (this.mServerSearcher == null) {
            this.mServerSearcher = new ServerSearcher();
            this.mServerSearcher.startSearch(this);
        }
    }

    private void stopSearchServer() {
        if (this.mServerSearcher != null) {
            this.mServerSearcher.stopSearch();
            this.mServerSearcher = null;
        }
    }
}

