/*
 * Decompiled with CFR 0.152.
 */
package com.sony.dps.dpscreencast.viewer;

import com.sony.dps.dpscreencast.viewer.DPController_EULADialog;
import com.sony.dps.dpscreencast.viewer.DPController_ScreenSync;
import com.sony.dps.dpscreencast.viewer.IUpdateRequest;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DPController_ScreenSyncWindow
extends JFrame {
    private static final long serialVersionUID = -7429547039791912844L;
    private static final int WIN_SIZE_X = 600;
    private static final int WIN_SIZE_Y = 800;
    private static final int WIN_MIN_SIZE_X = 300;
    private static final int WIN_MIN_SIZE_Y = 400;
    private static final boolean IS_RETINA = DPController_ScreenSyncWindow.isRetina();
    private JPanel mPanel;
    private BufferedImage mImage;
    private boolean mRotate = false;
    private int mLastW;
    private int mLastH;
    private File mImageFile;
    private String mImageFormat;
    private DPController_ScreenSync mScrSyncCom;

    public DPController_ScreenSyncWindow(File imageFile, String imageFormat) {
        ResourceBundle commonResources = ResourceBundle.getBundle("resources.CommonMessages");
        this.mImageFile = imageFile;
        this.mImageFormat = imageFormat;
        this.mPanel = new JPanel(){
            private static final long serialVersionUID = 4680767011483009972L;

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (DPController_ScreenSyncWindow.this.mImage != null) {
                    Graphics2D g2d;
                    int targetY;
                    int targetX;
                    int targetH;
                    int targetW;
                    int imageH;
                    int imageW;
                    Object hint;
                    boolean resizing;
                    int paneW = this.getWidth();
                    int paneH = this.getHeight();
                    boolean bl = resizing = paneW != DPController_ScreenSyncWindow.this.mLastW || paneH != DPController_ScreenSyncWindow.this.mLastH;
                    if (resizing) {
                        hint = RenderingHints.VALUE_RENDER_SPEED;
                        DPController_ScreenSyncWindow.this.mLastW = paneW;
                        DPController_ScreenSyncWindow.this.mLastH = paneH;
                    } else {
                        hint = RenderingHints.VALUE_RENDER_QUALITY;
                    }
                    BufferedImage image = DPController_ScreenSyncWindow.this.mImage;
                    boolean rotate = DPController_ScreenSyncWindow.this.mRotate;
                    if (!rotate) {
                        imageW = image.getWidth();
                        imageH = image.getHeight();
                    } else {
                        imageW = image.getHeight();
                        imageH = image.getWidth();
                    }
                    if (paneW * imageH <= paneH * imageW) {
                        targetW = paneW;
                        targetH = (int)Math.round((double)paneW * (double)imageH / (double)imageW);
                        targetX = 0;
                        targetY = (int)Math.round(((double)paneH * (double)imageW - (double)(paneW * imageH)) / (double)(imageW * 2));
                    } else {
                        targetH = paneH;
                        targetW = (int)Math.round((double)paneH * (double)imageW / (double)imageH);
                        targetX = (int)Math.round(((double)paneW * (double)imageH - (double)(paneH * imageW)) / (double)(imageH * 2));
                        targetY = 0;
                    }
                    int target2xW = targetW << 1;
                    int target2xH = targetH << 1;
                    if (!resizing) {
                        while (target2xW < imageW || target2xH < imageH) {
                            imageW = Math.max(imageW + 1 >> 1, target2xW);
                            imageH = Math.max(imageH + 1 >> 1, target2xH);
                            BufferedImage scaledImage = !rotate ? new BufferedImage(imageW, imageH, image.getType()) : new BufferedImage(imageH, imageW, image.getType());
                            g2d = scaledImage.createGraphics();
                            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, hint);
                            g2d.drawImage(image, 0, 0, scaledImage.getWidth(), scaledImage.getHeight(), null);
                            g2d.dispose();
                            image = scaledImage;
                        }
                    }
                    if (IS_RETINA && (target2xW != imageW || target2xH != imageH || rotate)) {
                        if (target2xW != imageW || target2xH != imageH) {
                            imageW = target2xW;
                            imageH = target2xH;
                        }
                        BufferedImage adjustedImage = new BufferedImage(imageW, imageH, image.getType());
                        g2d = adjustedImage.createGraphics();
                        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, hint);
                        if (!rotate) {
                            g2d.drawImage(image, 0, 0, imageW, imageH, null);
                        } else {
                            g2d.rotate(Math.toRadians(-90.0), imageH >> 1, imageH >> 1);
                            g2d.drawImage(image, 0, 0, imageH, imageW, null);
                            rotate = false;
                        }
                        g2d.dispose();
                        image = adjustedImage;
                    }
                    g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, hint);
                    if (!rotate) {
                        g2d.drawImage(image, targetX, targetY, targetW, targetH, null);
                    } else {
                        g2d.rotate(Math.toRadians(-90.0), paneH >> 1, paneH >> 1);
                        g2d.drawImage(image, targetY, targetX, targetH, targetW, null);
                    }
                    if (resizing) {
                        this.repaint();
                    }
                }
            }
        };
        this.mPanel.setBackground(Color.black);
        this.getContentPane().add(this.mPanel);
        this.setTitle(commonResources.getString("common.name"));
        this.pack();
        int horizontalInsets = this.getInsets().left + this.getInsets().right;
        int verticalInsets = this.getInsets().top + this.getInsets().bottom;
        this.setSize(600 + horizontalInsets, 800 + verticalInsets);
        this.setMinimumSize(new Dimension(300 + horizontalInsets, 400 + verticalInsets));
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        new DPController_EULADialog(this);
    }

    private static boolean isRetina() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac")) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = env.getDefaultScreenDevice();
            try {
                Field field = device.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object scale = field.get(device);
                    if (scale instanceof Integer && (Integer)scale == 2) {
                        System.out.println("Seems like retina display...");
                        return true;
                    }
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void startMirror() {
        this.mScrSyncCom = new DPController_ScreenSync(1200, 1600, new LocalResultListener());
        this.mScrSyncCom.start();
    }

    private class LocalResultListener
    implements IUpdateRequest {
        private LocalResultListener() {
        }

        @Override
        public void doUpdate(BufferedImage image) {
            if (image == null) {
                return;
            }
            DPController_ScreenSyncWindow.this.mImage = image;
            DPController_ScreenSyncWindow.this.mRotate = !DPController_ScreenSyncWindow.this.mScrSyncCom.isPortlate();
            DPController_ScreenSyncWindow.this.mPanel.repaint();
            if (DPController_ScreenSyncWindow.this.mImageFile != null) {
                try {
                    ImageIO.write((RenderedImage)image, DPController_ScreenSyncWindow.this.mImageFormat, DPController_ScreenSyncWindow.this.mImageFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

