/*
 * Decompiled with CFR 0.152.
 */
package com.sony.dps.dpscreencast.viewer;

import com.sony.dps.dpscreencast.common.PacketBase;
import com.sony.dps.dpscreencast.common.PacketHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import javax.imageio.ImageIO;

public class DPController_SockClient
extends Thread {
    private static final int SOC_TIMEOUT = 3000;
    private Socket mClientSock = null;
    private InputStream mInputStream = null;

    public void connectToServer(SocketAddress addr) throws IOException {
        this.mClientSock = new Socket();
        this.mClientSock.setTcpNoDelay(false);
        this.mClientSock.setSendBufferSize(8192);
        this.mClientSock.setSoTimeout(3000);
        this.mClientSock.connect(addr, 3000);
        this.mInputStream = this.mClientSock.getInputStream();
    }

    public void finalize() {
        try {
            if (this.mInputStream != null) {
                this.mInputStream.close();
                this.mInputStream = null;
            }
            if (this.mClientSock != null) {
                this.mClientSock.close();
                this.mClientSock = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PacketBase receivePacket() throws IOException {
        String tmp;
        if (this.mInputStream == null) {
            throw new IOException();
        }
        PacketBase ret = null;
        String data = "";
        byte[] buf = new byte[1];
        int size = 0;
        while ((size = this.mInputStream.read(buf)) != -1 && !(tmp = new String(buf)).equals("\n")) {
            data = data + tmp;
        }
        if (data != null) {
            ret = PacketHelper.createPacketFromString(data);
        }
        return ret;
    }

    public BufferedImage getBufferImage() throws IOException {
        if (this.mInputStream == null) {
            throw new IOException();
        }
        return ImageIO.read(this.mInputStream);
    }
}

