/*
 * Decompiled with CFR 0.152.
 */
package com.sony.dps.dpscreencast.viewer;

import com.sony.dps.dpscreencast.common.Constants;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Arrays;

public class ServerSearcher {
    private static final String BROADCAST_ADDR = "203.0.113.255";
    private static final int INTERVAL_TIME = 3000;
    private static final int SOC_TIMEOUT = 3000;
    private OnFoundListener mOnFoundListener;
    private SearcherThread mSearcher;

    public void startSearch(OnFoundListener listener) {
        this.stopSearch();
        this.mOnFoundListener = listener;
        this.mSearcher = new SearcherThread();
        this.mSearcher.start();
    }

    public void stopSearch() {
        this.mOnFoundListener = null;
        if (this.mSearcher != null) {
            this.mSearcher.destroy();
        }
    }

    public static interface OnFoundListener {
        public void onFound(SocketAddress var1);
    }

    private class SearcherThread
    extends Thread {
        private DatagramSocket mDgSocket;
        private InetAddress mInetAddress;
        private boolean mStopRcv = false;
        private DatagramPacket mCmdPacket;

        public void destroy() {
            this.mStopRcv = true;
            this.mDgSocket.close();
        }

        public SearcherThread() {
            try {
                this.mInetAddress = InetAddress.getByName(ServerSearcher.BROADCAST_ADDR);
                this.mDgSocket = new DatagramSocket(null);
                this.mCmdPacket = new DatagramPacket(Constants.UdpCmd.CMD_REQUEST_RESPONSE, Constants.UdpCmd.CMD_REQUEST_RESPONSE.length, this.mInetAddress, 54321);
                this.mDgSocket.setSoTimeout(3000);
                this.mDgSocket.setBroadcast(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            while (!this.mStopRcv) {
                SocketAddress destAddr = this.search();
                if (destAddr == null) continue;
                if (ServerSearcher.this.mOnFoundListener != null) {
                    ServerSearcher.this.mOnFoundListener.onFound(destAddr);
                }
                this.delay(3000L);
            }
        }

        private SocketAddress search() {
            try {
                System.out.println("[Searcher] send broadcast cmd!! ");
                this.mDgSocket.send(this.mCmdPacket);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] buf = new byte[1];
            DatagramPacket rcvpacket = new DatagramPacket(buf, buf.length);
            try {
                do {
                    this.mDgSocket.receive(rcvpacket);
                    System.out.println("[Searcher] received response! addr : " + rcvpacket.getSocketAddress() + "  data[0] " + rcvpacket.getData()[0]);
                } while (!Arrays.equals(rcvpacket.getData(), Constants.UdpCmd.CMD_RESPONSE));
                return rcvpacket.getSocketAddress();
            }
            catch (SocketTimeoutException e) {
                System.out.println("[Searcher] receive timeout!!");
            }
            catch (IOException e) {
                System.out.println("[Searcher] caught IOException!!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private void delay(long delayTime) {
            if (delayTime <= 0L) {
                return;
            }
            try {
                SearcherThread.sleep(delayTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

