#!/bin/sh
#
#  Power control daemon
#
#  Copyright 2002 Sony Corporation.
#
# chkconfig: 2345 05 05
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin

test -f /usr/local/anycast/bin/powctrld || exit 0

DAEMON=powctrld

case "$1" in
  start)
    major=`egrep powctrl /proc/devices | cut -f 1 -d ' '`
    if [ X${major} != X ]
    then
	    echo -n "Starting powerctrl daemon: ${DAEMON}"
	    start-stop-daemon --start --quiet --exec /usr/local/anycast/bin/powctrld
	    echo "."
    fi
    ;;
  stop)
    echo -n "Stopping powerctrl daemon: ${DAEMON}"
    start-stop-daemon --stop --quiet --pidfile /var/run/${DAEMON}.pid
    echo "."
    ;;
  restart)
    $0 stop
    $0 start
    ;;
  *)
    echo "Usage: /etc/init.d/powctrld {start|stop|restart}"
    exit 1
esac

exit 0
