#!/bin/sh
#
#  Set Factory Setting
#
PATH=/bin:/usr/bin:/sbin:/usr/sbin

AC_DIR=/usr/local/anycast
PIXDIR=$AC_DIR/pixmaps
ETCDIR=$AC_DIR/etc
VARDIR=$AC_DIR/var
VARS="CG CG_ATTR CG_THUM EDL_SRC JOB LAST LOG \
		LOGO LOGO_ATTR LOGO_THUM REAL SOZAI WORK"

test -d $VARDIR || exit 0

# delete lastdata
rm -f $VARDIR/LAST/lastdata1.*

# delete i18n data
rm -f $ETCDIR/.licence.AWSG500
rm -f $ETCDIR/lang.conf
ln -s $ETCDIR/lang.conf.en_US $ETCDIR/lang.conf

# delete work files
rm -rf $VARDIR/[^\.]*
rm -rf $VARDIR/\.[^\.]*
for var_sub in $VARS; do
	mkdir -p $VARDIR/$var_sub
done
ln -s $PIXDIR/SD_Safe_Area.tga.yuv $VARDIR/CG/SD_Safe_Area.tga.yuv
ln -s $PIXDIR/SD_Safe_Area.tga.attr $VARDIR/CG_ATTR/SD_Safe_Area.tga.attr
ln -s $PIXDIR/SD_Safe_Area.tga.uyvy $VARDIR/CG_THUM/SD_Safe_Area.tga.uyvy

# set default live.rm
rm -f /usr/local/helix/Content/broadcast/*.rm
ln -s $PIXDIR/live.rm /usr/local/helix/Content/broadcast/live.rm

exit 0
