:
# msformat.sh
# 2004.09.01

log=/usr/local/anycast/var/WORK/msformat_log.txt
log_w=/tmp/msformat_log.txt
rm -f ${log_w}
echo "### `date` ###" > ${log_w}
echo "> ${0} $*" >> ${log_w}

case "${1}" in
"-ms")
	# memory stick
	typ=1
	shift
	;;
"-fm")
	# flush memory
	typ=2
	shift
	;;
*)
	typ=1
	;;
esac

case $# in
1)
	opt="-v -I --full_format --device_side --process"
	op2="-v -I --quick_format --device_side --process"
	trg=${1}
	out=/usr/local/anycast/var/WORK/meflg
	mrk=/usr/local/anycast/var/WORK/mpflg
	;;
3)
	opt="-I --full_format --device_side --process=${1}"
	op2="-v -I --quick_format --device_side --process"
	trg=${2}
	out=${3}
	;;
*)
	# parameter ng
	echo "usage : ${0} {[-ms]|-fm} [msgkey status_file] pid_file"
	exit 1
esac

case $typ in
1)
	/usr/sbin/msmkdosfs ${opt} "${trg}" >> ${log_w} 2>&1
	/usr/sbin/msmkdosfs ${op2} "${trg}" >> ${log_w} 2>&1
	ext=$?
	;;
2)
	echo "> /sbin/sfdisk ${trg} 0,,b" >> ${log_w}
	/sbin/sfdisk ${trg} >> ${log_w} 2>&1 << EOF
0,,b
EOF
	ext=$?

	if test $ext -ne 0
	then
		# retry with force option
		echo "> /sbin/sfdisk ${trg} 0,,b" >> ${log_w}
		/sbin/sfdisk --force ${trg} >> ${log_w} 2>&1 << EOF
0,,b
EOF
		ext=$?
	fi
	if test $ext -eq 0
	then
		echo "/sbin/mkfs.msdos ${trg}1" >> ${log_w}
		/sbin/mkfs.msdos ${trg}1 >> ${log_w} 2>&1
		ext=$?
	fi
	;;
esac

echo ${ext} > ${out}

# save log file
if test ${ext} -ne 0
then
	echo "exit = ${ext}" >> ${log_w}
	cp -f ${log_w}	${log}
fi

echo "msformat exit=${ext}"
exit ${ext}
