
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: client.js,v 1.5 2003/09/27 00:54:33 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

	
var macIE_FormOffsetX = 30;
var macIE_FormOffsetY = 8;

// shortcut to Classes loaded in the top window
PropObj = top.PropObj ;
PropList = top.PropList ;
EditSelect2 = top.EditSelect2 ;

if ( window.name == "Main" )
{
	top.fMainFrameIsLocal = true ;
}

function isObj ( objToTest )
{
	return ( (objToTest != null) &&
			 (typeof(objToTest) == "object") );
}

// NOTE: Netscape evaluate the following to be true: ("" == 0)
// WORKAROUND: add "" to value
var UNDEFINED;
function isBlank ( varToTest )
{
	if ( varToTest == null )
		return true ;

	if ( (varToTest + "") == "" )
		return true ;

	if ( varToTest === UNDEFINED )
		return true ;

	return false ;
	
}	// isBlank ()

function rejectInput ( ctrl, errMsg, noSelect )
{
	function _doFocus ()
	{
		var ctrl = rejectInput.ctrl ;
		if ( ctrl && (typeof( ctrl ) == "object") )
		{
			if ( ctrl.type != "hidden" )
				ctrl.focus();

			if ( (!noSelect) && 
				 ((ctrl.type == "text") || (ctrl.type == "password")) )
				ctrl.select();
		}
	}

	if ( errMsg ) alert( errMsg );

	/*
		In Navigator, if the focus is set to control 'B' while in the
		middle of processing an onchange event for control 'A', another
		onchange event will be fired for control 'A' - that's bad. 
		
		The workaround is to delay the execution of the focus() method by using
		setTimeout().
	*/
	rejectInput.ctrl = ctrl ;
	if ( isNav ) window.setTimeout( "rejectInput._doFocus()", 100 );
	else _doFocus();

	return false ;
}

function getRadioCtrlValue ( radioGroup )
{
	if ( ! radioGroup )
	{
		
		return "";
	}

	for ( var i = 0; i < radioGroup.length; i++ )
	{
		var ctrl = radioGroup[ i ];
		if ( ctrl.checked )
		{
			return ctrl.value;
		}
	}

	return "";
	
}	// getRadioCtrlValue

function setRadioCtrlValue ( radioGroup, value, fSetAsDefault )
{
	if ( ! radioGroup )
	{
		
		return ;
	}

	for ( var i = 0; i < radioGroup.length; i++ )
	{
		var ctrl = radioGroup[ i ];
		ctrl.checked = (ctrl.value == value);
		if ( fSetAsDefault )
		{
			ctrl.defaultChecked = ctrl.checked;
		}
	}
	
}	// setRadioCtrlValue

function isRadioCtrlDirty ( radioGroup )
{
	if ( ! radioGroup )
	{
		
		return ;
	}

	for ( var i = 0; i < radioGroup.length; i++ )
	{
		var ctrl = radioGroup[ i ];
		if ( ctrl.defaultChecked != ctrl.checked )
		{
			return true ;
		}
	}

	return false;
	
}	// isRadioCtrlDirty

function isRadioGroup ( ctrl )
{
	return ( ctrl.length && ctrl[0] && ctrl[0].type && (ctrl[0].type == "radio") );
}

function getCtrlValue ( ctrl, bUseSelectText )
{
	if ( !ctrl )
	{
		
		return "";
	}

	switch( ctrl.type )
	{
		case "textarea" :
			// textarea control automatically adds a '\r' for/to each '\n'
			// this can screw up comparison functions so strip off the '\r's
			return ctrl.value.replace( /\r/g, "" );

		case "text" :
		case "hidden":
		case "submit":
		case "reset":
			return ctrl.value.trim();

		case "password":
			return ctrl.value;

		case "checkbox":
			return ctrl.checked ? "1" : "0" ;

		case "select-one" :
		case "select-multiple" :
		{
			if ( -1 == ( ctrl.selectedIndex ) )	
				return "" ;

			return bUseSelectText ? 
				ctrl.options[ ctrl.selectedIndex ].text : 
				ctrl.options[ ctrl.selectedIndex ].value ;
		}

		default:
			// radio ctrl ?
			if ( isRadioGroup( ctrl ) )
			{
				return getRadioCtrlValue( ctrl );
			}
			
			alert( "getCtrlValue(): Control type Not Implemented: " + ctrl.type + "\ncontrol name = " + ctrl.name );
			return "" ;

	}	// switch( ctrl.type )

}	// getCtrlValue ()

function getCtrlDefValue ( ctrl, bUseSelectText )
{
	if ( !ctrl )
	{
		
		return "";
	}
	
	switch( ctrl.type )
	{
		case "text" :
		case "hidden":
			return ctrl.defaultValue.trim() ;

		case "textarea":
		case "password":
			return ctrl.defaultValue ;

		case "checkbox":
			return ctrl.defaultchecked ? "1" : "0" ;

		case "select-one" :
		case "select-multiple" :
		{
			for ( var i = 0; i < ctrl.length; i++ )
			{
			    if ( ctrl.options[i].defaultSelected )
				{
					return bUseSelectText ? 
						ctrl.options[ i ].text : 
						ctrl.options[ i ].value ;
				}
			}
			return "" ;
			break;
		}

		default:
			alert( "getCtrlValue(): Control type Not Implemented: " + ctrl.type + "\ncontrol name = " + ctrl.name );
			return "" ;

	}	// switch( ctrl.type )

}	// getCtrlValue ()

function isCtrlDirty ( ctrl )
{
	if ( !ctrl )
	{
		
		return false;
	}

	switch( ctrl[ "type" ] )
	{
		case "text" :
		case "textarea" :
		case "hidden" :
		case "password" :
		    return ( ctrl.value != ctrl.defaultValue )

		/* select the original default option
		*/
		case "select-one" :
		case "select-multiple" :
		{
			for ( var x = 0; x < ctrl.options.length; x++ )
			{
			    if ( ctrl.options[x].selected != ctrl.options[x].defaultSelected )
					return true ;
			}
			return false ;
		}

		case "checkbox":
			return ( ctrl.checked != ctrl.defaultChecked )

		default:
			// radio ctrl ?
			if ( isRadioGroup( ctrl ) )
			{
				return isRadioCtrlDirty( ctrl );
			}
			break ;

	}	// swtich( ctrl.type )

	return false ;

}	// isCtrlDirty ()

function setCtrlValue ( ctrl, value, fSetAsDefault )
{
	if ( !ctrl )
	{
		
		return ;
	}

	switch( ctrl.type )
	{
		case "text" :
		case "textarea" :
		case "hidden" :
		case "password" :
		    ctrl.value = value ;
			if ( fSetAsDefault )
				ctrl.defaultValue = value ;
			break;

		/* for select lists, find and select the option whose
		   VALUE == this.m_props[ prop ].value
		   TODO: set/get multiple choices for select-multiple controls
		*/
		case "select-one" :
		case "select-multiple" :
			for ( var i = 0; i < ctrl.length; i++ )
			{
			    if ( ctrl.options[i].value == value )
				{
					ctrl.selectedIndex = i ;
					ctrl.options[i].selected = true;

					if ( fSetAsDefault )
					{
						ctrl.options[i].defaultSelected = true ;
					}
				}
				else 
				{
					ctrl.options[i].selected = false;
					if ( fSetAsDefault )
						ctrl.options[i].defaultSelected = false ;
				}
			}
			break;

		case "checkbox":
			ctrl.checked = 
			   ( (value != null ) && 
				 (value != false) &&
				 (value != "0"	) &&
				 (value != 0	) &&
				 (value != ""	) );
			if ( fSetAsDefault )
			{
				ctrl.defaultChecked = ctrl.checked ;
			}
			break;

		default:
			// radio ctrl ?
			if ( isRadioGroup( ctrl ) )
			{
				setRadioCtrlValue( ctrl, value, fSetAsDefault );
				break;
			}

			alert( "setCtrlValue(): Control type Not Implemented: " + ctrl.type + "\ncontrol name = " + ctrl.name );

	}	// swtich( ctrl.type )

}	// setCtrlValue ()

function focusFirstInForm ( f )
{
	if ( ! (f && f.elements && f.elements.length) )
		return ;

	var ctrl;
	for ( var i = 0; i < f.elements.length; i++ )
	{
		ctrl = f.elements[ i ];
		switch( ctrl[ "type" ] )
		{
			case "text" :
			case "textarea" :
			case "password" :
			case "select-one" :
			case "select-multiple" :
			case "checkbox":
			case "radio":
				ctrl.focus();
				return;

			default:
				break ;

		}	// switch( ctrl.type )
	}

}	// focusFirstInForm ()

function clearForm ( f )
{
	if ( ! (f && f.elements && f.elements.length) )
		return ;

	var ctrl;
	for ( var i = 0; i < f.elements.length; i++ )
	{
		ctrl = f.elements[ i ];
		switch( ctrl[ "type" ] )
		{
			case "text" :
			case "textarea" :
			case "hidden" :
			case "password" :
			    ctrl.value = "" ;
			    ctrl.defaultValue = "" ;
				break;

			/* select the original default option
			*/
			case "select-one" :
			case "select-multiple" :
			{
				var selX = 0;
				for ( var x = 0; x < ctrl.options.length; x++ )
				{
				    if ( ctrl.options[x][ "defaultSelected" ] )
					{
						selX = x ;
						break ;
					}
				}
	 			ctrl.selectedIndex = selX ;
				break;
			}

			case "radio":
			case "checkbox":
				ctrl.checked = ctrl.defaultChecked = false;
				break;

			default:
				break ;

		}	// swtich( ctrl.type )
	}

}	// clearForm ()

function isFormDirty ( f )
{
	if ( ! (f && f.elements && f.elements.length) )
		return null ;

	for ( var i = 0; i < f.elements.length; i++ )
	{
		if ( isCtrlDirty( f.elements[ i ] ) )
		{
			
			return f.elements[ i ];
		}
	}

	return null ;

}	// isFormDirty ()

function commitForm ( f )
{
	if ( ! f ) return ;
	
	if ( ! (f && f.elements && f.elements.length) )
		return ;

	var ctrl;
	for ( var i = 0; i < f.elements.length; i++ )
	{
		ctrl = f.elements[ i ];
		switch( ctrl[ "type" ] )
		{
			case "text" :
			case "textarea" :
			case "hidden" :
			case "password" :
			{
			    ctrl.defaultValue = ctrl.value;
				break ;
			}

			/* select the original default option
			*/
			case "select-one" :
			case "select-multiple" :
			{
				for ( var x = 0; x < ctrl.options.length; x++ )
				{
					ctrl.options[x].defaultSelected = ctrl.options[x].selected ;
				}
				break;
			}

			case "checkbox":
			case "radio":
				ctrl.defaultChecked = ctrl.checked ;
				break;

			default:
				break ;

		}	// swtich( ctrl.type )
	}

}	// commitForm ()

//deletes index option from select list, or deletes currently selected option
//if index == null 
function selectDel ( ctrl, index )
{
	if ( !ctrl ) return ;
	
	var curSelX = ctrl.selectedIndex ;
	if ( index == null ) index = curSelX ;

	if ( ctrl.length && (index >= 0) && (index < ctrl.length) )
	{
		ctrl.options[ index ] = null ;

		if ( index <= curSelX )
			ctrl.selectedIndex = Math.max( 0, curSelX - 1 );
	}

}	// selectDel()

//deletes index option from select list, or deletes currently selected option
//if index == null 
function selectReplace ( ctrl, oldValue, newValue, newText )
{
	if ( !ctrl ) return ;
	
	if ( ! newText ) newText = newValue

	var index = selectFind( ctrl, oldValue );

	if ( (index == null) || (index < 0) )
		return;

	ctrl.options[ index ].value = newValue;
	ctrl.options[ index ].text = newText;

}	// selectReplace()

// select the first element of a <SELECT> list box
// in IE, after resetting the list, selecting index 0 doesn't work if that was the last selection (I think)
// work-around is to set index to 1, then 0
function selectFirst ( ctrl )
{
	if ( !ctrl ) return ;

	if ( isIE )
	    ctrl.selectedIndex = 1;

    ctrl.selectedIndex = 0;
}

function copyIndexedArray ( aSrc )
{
	aDest = new Array();
	for ( var i = 0; i < aSrc.length; i++ )
	{
		aDest[ aDest.length ] = aSrc[ i ];
	}

	return aDest ;
	
}	// copyIndexedArray ()

function selectMoveItem ( selCtrl, moveAmount, itemIndexToMove )
{
	if ( !selCtrl ) return ;

	// zero or one items in the list? nothing to do
	var optCount = selCtrl.options.length;
	if ( optCount < 2 )
		return;

	// valid itemIndexToMove or current selection?
	var selX = (itemIndexToMove != null ? itemIndexToMove : selCtrl.selectedIndex );
	if ( isNaN(selX) || (selX < 0) || (selX >= optCount) )
		return ;

	// only move in increments of one
	if ( ! moveAmount )
		return ;
	if (moveAmount > 1)
		moveAmount = 1;
	else if (moveAmount < -1)
		moveAmount = -1;

	var newX = selX + moveAmount ;
	var nMax = optCount - 1 ;
	if ((newX < 0) || (newX > nMax))
		return ;	// can't move any further

	var tempValue = selCtrl.options[ selX ].value ;
	var tempText = selCtrl.options[ selX ].text ;

	selCtrl.options[ selX ].value = selCtrl.options[ newX ].value ;
	selCtrl.options[ selX ].text = selCtrl.options[ newX ].text ;
	selCtrl.options[ newX ].value = tempValue ;
	selCtrl.options[ newX ].text =  tempText ;

	// make the sure the moved Item is still selected
	selCtrl.selectedIndex = newX;

}	// selectMoveItem ()

/*
	Enumerates a 'property' array (i.e. associative array)
	pass a callback function to enum func with this signature:
	someCallbackFunc( array, property , curDepth )

	return non-zero from your callback to halt the enumeration

*/
function enumPropArray ( a, callback, maxDepth )
{
	if ( ! ( a && callback ) ) return ;

	// default maxDepth is zero, i.e. full recursion
	if ( enumPropArray.arguments.length < 3 ) maxDepth = 0 ;

	function _enumProps( a, curDepth, curPath )
	{
		if ( maxDepth && ( curDepth >= maxDepth ) ) return ;
		for ( var x in a )
		{
			// if callback returns a non-zero value that's a signal to abort the
			// enumeration

		    if( callback( a, x, curDepth, curPath + ( curPath ? "." + x : x ) ) ) return ;

			if ( typeof( a[ x ] ) == "object" )
			{
				curPath += ( curPath ? "." + x : x );
				curDepth++ ;
				_enumProps( a[ x ], curDepth, curPath ) 
				curDepth-- ;
				curPath = curDepth ? curPath.leftProp( -1 ) : "" ;
			}
		}	
	}

	_enumProps( a, 0, "" );
}

function selectFind ( selCtrl, strToFind, fSearchText )
{
	if ( !selCtrl ) return -1 ;

	var index = -1;

	for ( var i = 0; i < selCtrl.options.length; i++ )
	{
		if ( fSearchText )
		{
			if ( strToFind == selCtrl.options[ i ].text )
				return i;
		}
		else
		{
			if ( strToFind == selCtrl.options[ i ].value )
				return i;
		}
	}

	return -1 ;

}	// selectFind ()

function selectPush ( selCtrl, text, value, max, bubble, listOffset )
{
	if ( !selCtrl ) return ;

	if ( value == null ) value = text;

	if ( listOffset == null || 
		 (listOffset != parseInt( listOffset )) )
	{
		 listOffset = 0 ;
	}

	// move everybody down, cutting off after 20 items
	if ( selCtrl.options.length )
	{
		var len = selCtrl.options.length - 1;
		if ( max ) len = Math.min( max-1, len );

		// if we encounter the same option that we're about to add
		// just skip it here and bubble it to the top of the list
		if ( bubble && selCtrl.options.length )
		{
			for ( var i = listOffset; i < selCtrl.options.length; i++ )
			{
				if ( value == selCtrl.options[ i ].value )
				{
					len = i - 1;
					break;
				}
			}
		}
		
		for ( var i = len; i >= listOffset; i-- )
		{
			selAddOption( selCtrl, 
				selCtrl.options[ i ].text, 
				selCtrl.options[ i ].value, 
				false, i + 1 );
		}
	}
	selAddOption( selCtrl, text, value, false, listOffset );

}	// selectPush ()

/*********************************************************

window procs

*/

function _openDialog
( 
	href,	// window src document
	name,	// optional window name (default = 'DIALOG')
	options	// optional window features (see window.open API, def = 'resizable=no,scrollbars=no,width=460,height=360,screenX=200,screenY=200,dependent')
)
{
	if ( ! href ) return null ; // can't do nuthin'

    var newWindow = null ;
	var defName = 'DIALOG' ;
	var defOptions = 'resizable=no,scrollbars=no,width=460,height=360,screenX=200,screenY=200,dependent' ;

	// set up defaults
	if ( ! options ) options = defOptions ;
	if ( ! name ) 	 name 	 = defName ;

    newWindow = window.open( href, name, options );

	// IE won't let us call focus method on the newWindow if its in another domain!
	// HACK: if a protocal//host is specified in the HREF, assume it's in another domain
	// HACK: no focus at all for IE with remote documentation
	//if ( newWindow && ( isNav || ( -1 == href.indexOf( ':' ) ) ) )
	if ( newWindow && isNav )
		newWindow.focus();

	return newWindow ;
}

/**********

	Help Window

*/

/* ------------ opens custom dialog box to display inline help --------------*/

// call this function from any page to display its related help file/anchor

function launchAbout ()
{
	_openDialog( "license.html", 'aboutMe', 'toolbar=no,status=no,scrollbars=yes,resizable=no,menubar=no,width=616,height=540,dependent=yes' );
}

function findFrame ( frameName )
{
	
	return top[ frameName ];
}

function buildParam ( paramName, paramValue )
{
	
	return "&" + escapePlus( paramName ) + "=" + escapePlus( paramValue );
}

function sortCaseInsensitive ( a, b )
{
	if (a == null) return -1;
	if (b == null) return 1;

	if( (parseInt(a) == a) && 
	    (parseInt(b) == b) )
	{
	 	return ( parseInt(a) < parseInt(b) ? -1 : 1 );
	}
	else if( (typeof(a) == "number") && 
	    	 (typeof(b) == "number") )
	{
	 	return ( a < b ? -1 : 1 );
	}
	else
	{
		return ( a.toString().toLowerCase() < b.toString().toLowerCase() ? -1 : 1 );
	}
}

function sortObjKeys ( obj )
{
	var aTmp = [];
	if ( isObj( obj ) )
	{
		for ( var key in obj )
		{
			aTmp[ aTmp.length ] = key;
		}
		if ( isNav4 )
		{
			aTmp.sort();	
		}
		else
		{
			aTmp.sort( sortCaseInsensitive );
		}
	}

	return aTmp;
}

function testURL ( urlCtrlID )
{
	if ( ! urlCtrlID ) return;

	var urlCtrl = getElem( urlCtrlID );
	if ( ! urlCtrl ) return;
	
	var url = getCtrlValue( urlCtrl );
	if ( ! isBlank( url ) )
	{
		window.open( url, "TEST_URL" );
	}
	else
	{
		rejectInput( urlCtrl, "Please enter a valid URL." );
	}
}

function activateLink ( urlCtrlID, linkSpanID )
{
	if ( isNav4 || !(urlCtrlID &&linkSpanID) ) return ;

	var link = getElem( "URL_LINK" );
	
	var urlCtrl = getElem( urlCtrlID );
	if ( ! urlCtrl ) return ;

	var linkSpan = getElem( linkSpanID );
	if ( ! linkSpan ) return ;

	if ( urlCtrl.value != "" )
	{
		if ( link == null )
			linkSpan.innerHTML = "<A CLASS='linkText' TITLE='Test the " + linkSpan.innerHTML + " in a separate browser window' ID='URL_LINK' HREF='javascript:testURL( \"" +  urlCtrlID + "\")'>" + linkSpan.innerHTML + "</A>" ;
	}
	else
	{
		if ( link )
			linkSpan.innerHTML = link.innerHTML ;
	}
}

function fillSelectCtrlFromPropArray ( selCtrl, propArray, propToUse, offset )
{
	var aTmp = [];
	function _callback ( array, prop, curDepth )
	{
		aTmp[ aTmp.length ] = prop ;
	}
	enumPropArray( propArray, _callback, 1 ); 
	aTmp.sort();

	if ( offset == null ) offset = selCtrl.length;

	var listName, displayText;
	for ( var i = 0; i < aTmp.length; i++ )
	{
		listName = displayText = aTmp[ i ];

		if ( propToUse && 
			 propArray[ listName ] && 
			 propArray[ listName ][ propToUse ] )
		{
			displayText = propArray[ prop ][ propToUse ];
		}
		
		selAddOption( selCtrl, displayText, listName, false, offset++ );
	}

}	// fillSelectCtrlFromPropArray

function selAddGeneric ( selCtrl, generic, incAmount, suffix )
{
	if ( ! selCtrl ) return "";

	generic = selGetNextGeneric( selCtrl, generic, incAmount, suffix );

	// add to list and select
	selAddOption( selCtrl, generic, generic, true );

	return generic ;
}

function selGetNextGeneric ( selCtrl, generic, incAmount, suffix )
{
	if ( ! selCtrl ) return "";
	if ( generic == null ) generic = "Untitled" ;
	if ( isNaN(parseInt(incAmount)) ) incAmount = 1;
	if ( suffix == null ) suffix = "" ;

	var regExp = new RegExp( "^" + escRegExMetaChars( generic ) + "(\\d+)" + 
  							       escRegExMetaChars( suffix ) + "$", "i" );

	// loop through the list looking for elements with the form 
	// <defTitle>[0-9]+

	var max = 0 ;
	for ( var i = 0; i < selCtrl.options.length; i++ )
	{
		var tempA = selCtrl.options[ i ].value.match( regExp );
		if ( tempA && parseInt( tempA[ 1 ] ) > max ) max = parseInt( tempA[ 1 ] );
	}

	generic += ( max + incAmount ) + suffix ; 

	return generic;
	
}	// selGetNextGeneric

function selAddOption ( selCtrl, optText, optValue, fSelect, index )
{
	if ( (!selCtrl) || isBlank(optText) ) 
	{
		return;
	}

	if ( optValue == null )
	{
		optValue = optText;
	}

	if ( index == null )
	{
		index = selCtrl.options.length;
	}

	if ( fSelect == null )
	{
		fSelect = false;
	}

	var opt;
	if ( ! isIE5Up )
	{
		opt = new Option( optText, optValue, false );
	}
	else
	{
		
		opt = selCtrl.document.createElement( "OPTION" );
		opt.text = optText ;
		opt.value = optValue ;
		opt.selected = fSelect ;
	}
	selCtrl.options[ index ] = opt ;

	if ( (!isIE5Up) && fSelect )
	{
		// the selected param in the Option constructor is not recognized
		selCtrl.selectedIndex = index;
	}
	
}	// selAddOption

function validatePassword ( ctrlName, isRequired, oForm )
{
	if ( ! oForm ) oForm = theForm;

	if ( ! oForm ) return true;

	var passCtrl = oForm[ ctrlName ];

	if ( ! passCtrl ) return true;

	if ( ! oForm[ ctrlName + "2" ] ) return true;

	var pass1 = getCtrlValue( passCtrl );
	if ( isRequired && isBlank( pass1 ) )
		return rejectInput( passCtrl, "A Password is required." );

    if ( pass1 != getCtrlValue( oForm[ ctrlName + "2" ] ) )
	{
		setCtrlValue( oForm[ ctrlName + "2" ], "" );
		return rejectInput( passCtrl, "Passwords do not match." );
	}

	return true;

}	// validatePassword

/*
function findPropInObj

	//given an object:
	{
		"Enabled":0
		,"LoggingStyle":0
		,"Type":"AccessLog"
		,"Outputs":
		{
			"File1":
			{
				"Filename":"logs/access.log"
				,"Type":"File"
			}
		}
	}

	and a PropPath:
	"Outputs.File1.Filename"

	returns:

	"logs/access.log"

	returns null if any part of the porperty path is not found in the object

*/
function findPropInObj ( o, propPath )
{
	if ((!isObj(o)) || isBlank(propPath))
	{
		return null;
	}

	if (-1 == propPath.indexOf( "." ))
	{
		return (isBlank(o[ propPath ]) ? null : o[propPath]);
	}
	else
	{											
		if ( ! isObj( o[propPath.leftProp(1)] ))
		{
			return null;
		}
		else
		{
			return findPropInObj(o[propPath.leftProp(1)], 
									propPath.rightProp(-1));
		}
	}					
}					

