
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: cookies.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

// The constructor function: creates a cookie object for the specified
// document, with a specified name and optional attributes.
// Arguments:
//   document: The Document object that the cookie is stored for. Required.
//   name:     A string that specifies a name for the cookie. Required.
//   hours:    An optional number that specifies the number of hours from now
//             that the cookie should expire.
//   path:     An optional string that specifies the cookie path attribute.
//   domain:   An optional string that specifies the cookie domain attribute.
//   secure:   An optional Boolean value that, if true, requests a secure cookie.
//
function Cookie(document, name, hours, path, domain, secure)
{
    // All the predefined properties of this object begin with '$'
    // to distinguish them from other properties which are the values to
    // be stored in the cookie.
    this.$document = document;
    this.$name = name;
    if (hours)
        this.$expiration = new Date((new Date()).getTime() + hours*3600000);
    else this.$expiration = null;
    if (path) this.$path = path; else this.$path = null;
    if (domain) this.$domain = domain; else this.$domain = null;
    if (secure) this.$secure = true; else this.$secure = false;
}

Cookie.prototype.store = function ()
{
    // First, loop through the properties of the Cookie object and
    // put together the value of the cookie. Since cookies use the
    // equals sign and semicolons as separators, we'll use colons
    // and ampersands for the individual state variables we store 
    // within a single cookie value. Note that we escape the value
    // of each state variable, in case it contains punctuation or other
    // illegal characters.
    var cookieval = "";
    for(var prop in this) {
        // Ignore properties with names that begin with '$' and also methods.
        if ((prop.charAt(0) == '$') || ((typeof this[prop]) == 'function')) 
            continue;
        if (cookieval != "") cookieval += '&';
        cookieval += prop + ':' + escape(this[prop]);
    }

    // Now that we have the value of the cookie, put together the 
    // complete cookie string, which includes the name and the various
    // attributes specified when the Cookie object was created.
    var cookie = this.$name + '=' + cookieval;
    if (this.$expiration)
        cookie += '; expires=' + this.$expiration.toGMTString();
    if (this.$path) cookie += '; path=' + this.$path;
    if (this.$domain) cookie += '; domain=' + this.$domain;
    if (this.$secure) cookie += '; secure';

    // Now store the cookie by setting the magic Document.cookie property.
    this.$document.cookie = cookie;
}

Cookie.prototype.load = function ()
{
    // First, get a list of all cookies that pertain to this document.
    // We do this by reading the magic Document.cookie property.
    var allcookies = this.$document.cookie;
    if (allcookies == "") return false;

    // Now extract just the named cookie from that list.
    var start = allcookies.indexOf(this.$name + '=');
    if (start == -1) return false;   // Cookie not defined for this page.
    start += this.$name.length + 1;  // Skip name and equals sign.
    var end = allcookies.indexOf(';', start);
    if (end == -1) end = allcookies.length;
    var cookieval = allcookies.substring(start, end);

    // Now that we've extracted the value of the named cookie, we've
    // got to break that value down into individual state variable 
    // names and values. The name/value pairs are separated from each
    // other by ampersands, and the individual names and values are
    // separated from each other by colons. We use the split method
    // to parse everything.
    var a = cookieval.split('&');    // Break it into array of name/value pairs.
    for(var i=0; i < a.length; i++)  // Break each pair into an array.
        a[i] = a[i].split(':');

    // Now that we've parsed the cookie value, set all the names and values
    // of the state variables in this Cookie object. Note that we unescape()
    // the property value, because we called escape() when we stored it.
    for(var i = 0; i < a.length; i++) {
        this[a[i][0]] = unescape(a[i][1]);
    }

    // We're done, so return the success code.
    return true;
}

Cookie.prototype.remove = function ()
{
    var cookie;
    cookie = this.$name + '=';
    if (this.$path) cookie += '; path=' + this.$path;
    if (this.$domain) cookie += '; domain=' + this.$domain;
    cookie += '; expires=Fri, 02-Jan-1970 00:00:00 GMT';

    this.$document.cookie = cookie;
}

Cookie.prototype.fillSelList = function ( listCtrl, cookiePrefix, listOffset, maxListLength )
{
	if ( ! (listCtrl && cookiePrefix) ) return;

	if ( listOffset == null || 
		 (listOffset != parseInt( listOffset )) )
	{
		 listOffset = 0 ;
	}

	var regEx = new RegExp( "^" + escRegExMetaChars( cookiePrefix ) + "([\\d]+)" );

	var aTemp = new Array();
	for( var prop in this )
	{
		// Ignore properties with names that begin with '$' and also methods.
		if ((prop.charAt(0) == '$') || (typeof(this[prop]) == 'function')) 
		 	continue;

		// and parse the list ordinal out
		var a = prop.match( regEx );
		if ( !a ) continue;

		var listValue = this[ prop ];
		if ( ! isBlank( listValue ) )
		{
			aTemp[ parseInt(a[1]) ] = listValue;
		}
	}

	for ( var i = 0; i < aTemp.length; i++ )
	{
		var listValue = aTemp[ i ];
		if ( ! isBlank( listValue ) )
		{
			selAddOption( listCtrl, listValue );

			if ( maxListLength && (listCtrl.options.length >= maxListLength) )
				break;
		}
	}
	
}	// fillSelList ()

Cookie.prototype.saveSelList = function ( listCtrl, cookiePrefix, listOffset, listMaxLen )
{
	if ( ! (listCtrl && cookiePrefix) ) return;
	
	if ( listOffset == null || 
		 (listOffset != parseInt( listOffset )) )
	{
		 listOffset = 0 ;
	}

	var nSaveCount = 0;

	// save all the list items as cookies <cookiePrefix>i=list.options[i].value
	for ( var i = listOffset; i < listCtrl.options.length; i++ )
	{
		this[ cookiePrefix + (i-listOffset) ] = listCtrl.options[ i ].value;
		if ( listMaxLen )
		{
			nSaveCount++ ;
			if ( nSaveCount >= listMaxLen )
				break ;
		}
	}

	// if we saved listMaxLen-N items, overwrite any old cookies between listMaxLen-N and listMaxLen
	if ( listMaxLen )
	{
		for ( var i = nSaveCount; i <= listMaxLen; i++ )
		{
			delete this[ cookiePrefix + (i-listOffset) ];
		}
	}

	// store in the cookie
	this.store();
}
