
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: datachn.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

var frameFile = "datachannel.html" ;

function DataChannel ( frameName )
{
	if ( top.gDataChannel != null ) return top.gDataChannel ;

	this.m_frameName					= frameName ;

	this.dataReadyCallback 			= null ;
	this.dataReadyCallbackUserArgs	= null ;
	this.inUse 						= false ;
	this.m_frame					= null ;

	return this ;
}

DataChannel.prototype.frameName = function ()
{
	if ( (arguments.length == 0) || (! arguments[ 0 ]) )
	{
		return this.m_frameName ;
	}
	else
	{
		var oldName = this.m_frameName ;
		this.m_frameName = arguments[ 0 ];
		this.m_frame = findFrame( this.m_frameName );
		return oldName ;
	}
}

DataChannel.prototype.frame = function ()
{
	if ( (arguments.length == 0) || (! arguments[ 0 ]) )
	{
		return this.m_frame ;
	}
	else
	{
		// is this really a window?
		if ( typeof( frame ) == "object" && frame.document )
		{
			this.m_frame = arguments[ 0 ];
			this.m_frameName = this.m_frame.name ;
			// no return value: old frame may be gone
		}
	}
}

DataChannel.prototype.setDataReadyCallback = function ( callback, userArgs )
{
	this.dataReadyCallback 			= callback ;
	this.dataReadyCallbackUserArgs	= userArgs ;
}

DataChannel.prototype.getServerData = function ()
{
	// force the dataChannel to refresh and fetch the property data
	if ( ! this.inUse )
	{
		/*
			arguments are registry property names whose values we'll fetch 
			from the dataChannel, we tell the server what properties we're interested 
			in by passing them in the query string of the datachannel URL
		*/
		var qStr = "" ;
		for ( var i = 0; i < arguments.length; i++ )
		{
			if ( (arguments[ i ] != null) && (arguments[ i ] != "") )
				qStr += arguments[ i ] + '=&' ;
		}

		this.go( qStr );
	}

}	// getServerData

DataChannel.prototype.go = function ( qStr )
{
	if ( ! this.m_frame ) this.m_frame = findFrame( this.m_frameName );

	if ( this.m_frame )
	{
		this.inUse = true ;
		this.m_frame.location = frameFile + "?" + qStr ;
	}
}

DataChannel.prototype.chgConfig = function
( 
	chgType,			// "servvar" or "configvar"
	chgParams 			// parameter string to submit to server
)
{
	if ( ! this.m_frame ) this.m_frame = findFrame( this.m_frameName );

	if ( this.m_frame )
	{
		// TODO reuse raSubmitCHnages for this
		//	PROCESS ARGS for bad things
		// strip off leading/trailing '&' seperators
		chgParams = chgParams.replace( /^&*/, '' );
		chgParams = chgParams.replace( /&*$/, '' );
		var url = chgType + ".set.html?respage=datachannel.html&" + chgParams ;

		this.inUse = true ;
		this.m_frame.location.href = url ;
	}
}

// when the dataChannel has finished loading we'll be notified via this function
DataChannel.prototype.onDataReady = function ()
{
	//alert( "data has arrived" );

	// make sure we really need to fire the event
	if ( this.dataReadyCallback && this.inUse)
	{
		this.dataReadyCallback( this.dataReadyCallbackUserArgs );
	}

	this.inUse = false ;
}

