
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: dialog.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

/* Globals */

var theForm ;
var gParams = window.opener.dlgParams ;
var onLoadHookFunc = null;

function _onLoadDefault ()
{
	theForm = document.theForm;

	if ( gParams ) gParams.isOpen = true ;

	focusFirstElement();

	if ( isNav ) document.captureEvents( Event.KEYDOWN );
	document.onkeydown = _onKeyDefault ;

	if ( onLoadHookFunc ) onLoadHookFunc();
}	

function _onUnLoadDefault ()
{
	if ( gParams ) 
	{
		gParams.isOpen = false ;
		if ( gParams.bCloseOpenerOnClose && window.opener )
		{
			window.opener.close();
		}
	}
}	

// handle ESCape key: simulate Cancel button
// handle ENTER/RETURN key: simulate OK button
// NOTE: Nav doesn't seem to capture the ESC key
function _onKeyDefault ( evt )
{
	var keyCode = ( isIE ) ? event.keyCode : evt.which

	switch ( keyCode )
	{
		case 27:	// ESCape
			theForm.onreset();
			return false ;

		case 13:	// ENTER
			if ( isNav )
			{
				if ( theForm.onsubmit() )
					theForm.submit();
				return false ;
			}
	}
	return true ;
}

function doDlgClose ( fOK )
{
	if ( fOK && (gParams.OKHandler != null) )
		gParams.OKHandler( formToObject( theForm, gParams.userParams ) );

	window.close();

	return true;
}

function formToObject ( f, obj )
{
	if ( ! f ) return obj ;
	if ( ! obj ) obj = new Object();

	var ctrl ;
	for ( var i = 0; i < f.elements.length; i++ )
	{
		ctrl = f.elements[ i ];
		switch( ctrl.type )
		{
			case "submit":
			case "reset":
				break ;

			default :
				obj[ ctrl.name ] = getCtrlValue( ctrl );
				break ;
		}
	}

	return obj ;	
}

function focusFirstElement ()
{
	if ( ! theForm ) return ;
	
	for ( var i = 0 ; i < theForm.elements.length ; i++ )
	{
		var ctrl = theForm.elements[ i ];
		switch( ctrl.type )
		{
			case "text" :
			case "textarea" :
			case "password" :
			case "select-one" :
			case "select-multiple" :
			case "checkbox":
			case "radio":
			case "submit":
			case "reset":
				if ( isIE && ( ctrl.readOnly || ctrl.disabled ) )
					break ;

				ctrl.focus();	
				return ;

			default:
				break ;

		}	// swtich( ctrl.type )
	}
}
