
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: help.js,v 1.3 2003/10/08 22:53:17 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

/* 	token passed from the 		:  
   	admin system, usually the	:	  Manual filename and anchor that best helps the user 
   	page name from where the    :	  Use the empty string ("") to indicate that there
   	docs were summoned -		:	  is no help available on that topic. All files are
   	the 'context' in 			:	  assumed to live in htmfiles/
   	'context sensitive'		    :

	sorted & grouped according to the Server 9 TOC for ease of maintanence
*/

var helpWinName = 'helpMe' ;
var helpWinOptions = 'toolbar=yes,status=no,scrollbars=yes,resizable=yes,menubar=yes,width=800,height=';
helpWinOptions += parseInt(screen.availHeight * .8);

function launchHome ( fileName, options )
{
	// opens external content in seperate window
	_openDialog( fileName, "realHome", options ? options : helpWinOptions );
}

var adminLinkMap = 
{
	"header"					: "intro.htm"
	,"welcome"					: "install.htm"
	,"config_ports"				: "setup.htm#ports"
	,"config_binding"			: "setup.htm#ipaddr"
	,"config_mimetypes"			: "setup.htm#mime_types"
	,"config_cc"				: "setup.htm#connections"
	,"config_altserv"			: "large.htm#redundant_servers"
	,"config_localFS"			: "links.htm#add_point"
	,"config_alias"				: "links.htm#create_alias"
	,"config_delivery"			: "setup.htm#http_delivery"
	,"config_pc_cache"			: "large.htm#proxy_restrict"
	,"config_license_pub"		: "setup.htm#distributed_publish"
	,"config_license_sub"		: "setup.htm#distributed_subscribe"
	,"config_setid"				: "setup.htm#unix_user"

	,"config_sec_ac"			: "limiting.htm#a_acontrol"
	,"config_sec_db"			: "authentg.htm#new_db"
	,"config_sec_uauth"	   		: "authentg.htm#passwords"
	,"config_sec_rules"	   		: "authentg.htm#commerce_rules"
	,"adduser"	 		  		: "authentg.htm#adduser"
	,"edituser"	 		  		: "authentg.htm#edituser"
	,"removeuser"	 	  		: "authentg.htm#removeuser"
	,"getusers"	 		  		: "authentg.htm#getusers"
	,"grantuser"	 		  	: "authentg.htm#grantuser"
	,"edituserperm"	 		  	: "authentg.htm#edituserperm"
	,"revokeuser"	 	  		: "authentg.htm#revokeuser"
	,"revokealluser"	 		: "authentg.htm#revokealluser"
	,"add_redirect"	 		  	: "authentg.htm#add_redirect"
	
	,"mongraph"					: "monitor.htm#server_monitor"
	,"mongraph_ntperfmon"		: "monitor.htm#NT_performance"
	,"config_logging"			: "report.htm#access_read"
	,"config_logging_error"		: "report.htm#error_read"
	,"config_clog"				: "dynamic_.htm#create_template"
	,"lic_mon0"					: "setup.htm#distributed_start"

	,"config_broad_real"		: "strmlive.htm#broadcast_real"
	,"config_broad_rtp"			: "strmlive.htm#rtp_encode"
	,"config_broad_wm"			: "strmlive.htm#brdcst_wmt"
	,"config_broad_wm_asxgen"  	: "links.htm#asxgen"
	,"config_broad_archive"		: "strmlive.htm#archive_setup"
	,"config_broad_redun"		: "strmlive.htm#redundant_setup"

	,"config_spl_dist"			: "spliting.htm#transmitter"
	,"config_spl_recv"			: "spliting.htm#receiver"
	,"config_mc_scale"			: "multicst.htm#scalable"
	,"config_mc_bc"				: "multicst.htm#bchannel"
	,"config_mc_wm"				: "multicst.htm#wmpcast"
	,"config_mc_sap"			: "multicst.htm#sap_announce"

	,"config_cdist"				: "large.htm#content_subscribe"
	,"config_isp"				: "isp.htm#setup"
	,"config_content_browsing"	: "links.htm#browse"
	,"config_viewsrc"	   		: "links.htm#view_change"

	,"config_adserv"			: "adserve.htm#ad_mountpoint"
	,"config_smilgen"	   		: "adserve.htm#ad_smilpoint"
	,"config_smilgen_limits"	: "adserve.htm#limitations"
	,"config_admisc"			: "adserve.htm#ad_timeout"
	,"config_qos"				: "setup.htm#differentiated_services"
	,"config_rate"				: "setup.htm#rate_control"

};

function getHelpPath ( context )
{
	var path = "";

	// look in the linkmap for physical link associated with startPage
	if ( adminLinkMap && adminLinkMap[ context ] )
	{
		 path = "htmfiles/" + adminLinkMap[ context ];
	}
	else if ( context )
	{
    	path = "htmfiles/" + context ;
	}
	else
	{
    	path = "htmfiles/title.htm" ;
	}

	return path;
}

function contextHelp ( helpLink )
{

	
	var docPath = "Docs/Manual/" ;

	var helpFrameset = "realsrvr.htm" ;

	//if no helplink just use the current filename minus path & extension
	// i.e. admin/config_ports.html => config_ports
	if ( ! helpLink )
	{
		helpLink = location.pathname;
		var pos = helpLink.lastIndexOf( '/' );
		if ( pos != -1 )
			helpLink = helpLink.slice( pos + 1 );

		pos = helpLink.indexOf( '.' );
		if ( pos == -1 ) 
			pos = helpLink.indexOf( '#' );
		if ( pos == -1 ) 
			pos = helpLink.indexOf( '?' );

		if ( pos != -1 ) 
			helpLink = helpLink.slice( 0, pos );
	}

	helpLink = getHelpPath( helpLink );

	// if our help window is already open, just switch to it and navigate 
	// to the bookmark
	var win = top.helpWin ;
	if ( win && (! win.closed) && (!docPath.bSearch( /^http/i )) )
	{
		
		win.body.location = docPath + helpLink ;
		win.focus();
	}
	else	// open help win and load help frameset, pass helpLink in querystring
	{
		if ( helpLink )
			helpFrameset += "?goto=" + escape( helpLink );

		
		launchHelp( docPath + helpFrameset );
	}

}	// contextHelp ()

function launchHelp ( fileName, options )
{
	// stuff window ref in topmost parent window
	top.helpWin = _openDialog( fileName, helpWinName, options ? options : helpWinOptions );
}

