
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: propview_enum.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

//<SCRIPT>

/* EnumEditSelect is a subclass of the EditSelect2 class, done so we can override the
	getNextUntitledIncrement funtion()
*/
function EnumEditSelect2 ( oWin, selectCtrl, editCtrl, oCallback /*instance of NestedPropListView */ )
{
	this.base = EditSelect2 ;
	this.base( oWin, selectCtrl, editCtrl, oCallback );

	// since the edit box isn't tied to a <List> name we can turn off the check for "." and '"' chars
	this.m_reIllegalChars = null;
}
EnumEditSelect2.prototype = new EditSelect2 ;

/* use the next highest hundred, instead of incrementing by one */
EnumEditSelect2.prototype.getNextUntitledIncrement = function ( curMax )
{
	var nextInc = ( curMax + 100 - ( curMax % 100) );

	return nextInc;
}

function NestedEnumPropListView ( listName, propList, itemLabel, 
				configRootPath, serverMethod, sFormName, sListname, sEditname, aDirtyImgNames, 
				listPropName, listPropDefValue )
{
	this.base = NestedPropListView ;
	this.base( listName, propList, itemLabel, configRootPath, serverMethod,
		sFormName, sListname, sEditname, aDirtyImgNames );

	this.m_fillListPropName = listPropName;
	this.m_listPropDefValue = listPropDefValue ;
	this.m_enumPrefix = "";
}
NestedEnumPropListView.prototype = new NestedPropListView ;

NestedEnumPropListView.prototype.onLoad = function ( oWin, fNoInitForm, fNoDisplayData )
{

	if ( ! isXblibInit ) xblibInit();

	// initialize member variables TODO validate parameters	
	this.m_oWin = oWin;
	this.m_oDoc = oWin ? oWin.document : null ;

	this.m_bLoaded = true ;

	// 
	if ( this.preOnLoad() )
	{
		this.m_propList.reset();

		if( this.m_bDoDirtyCheck )
			this.showDirtyFlag( false );

		if ( ! fNoInitForm )
			clearForm( this.getForm() );

		// create or (if in reset mode) sync the EditSelct object
		if ( ! this.m_oES )
		{
			this.m_oES = new EnumEditSelect2( this.m_oWin, this.getListCtrl(), this.getEditCtrl(), this );
			this.m_oES.m_syncTextAndValue = false ;
			this.m_oES.itemName( this.m_itemLabel );
		}

		//init any subViews
		for ( var subViewName in this.m_subViews )
		{
			var subView = this.m_subViews[ subViewName ];
			if ( subView )
			{
				subView.onLoad( oWin, true );
			}
		}

		if ( ! fNoDisplayData )
		{
			this.initListDataDisplay();
		}

		if ( ! fNoInitForm )
			this.hookForm();
	}
	this.postOnLoad();
}

NestedEnumPropListView.prototype.fillSelectList = function ()
{
	var listCtrl = this.getListCtrl();
	if ( listCtrl )
	{
		listCtrl.length = 0 ;
		
		// fill the list 
		//		value = sublist name
		//		text = value of m_fillListPropName
		this.m_subListParent.fillSelectList2( listCtrl, this.m_fillListPropName );
		
		// and select the first one
		selectFirst( listCtrl );
	}
}

// *******  ADD / EDIT / REMOVE / COPY SUBLIST FUNCTIONS ********

NestedEnumPropListView.prototype.onESRename = function ( oldSubListName, newSubListName )
{
	// for enumerated sub list, we're hiding the sublist name, so a
	// change to the seltext is really just a change to the fillListPropName
	// we don't have to do anything special here about that

	if( this.m_bDoDirtyCheck )
		this.showDirtyFlag( false );

	return true ;

}	// onESRename ()

NestedEnumPropListView.prototype.createSubList = function ()
{
	// validate and save the current list's values
	if ( this.m_curSubListName && ( ! this.validateSubList() ) ) 
	{
		return ;
	}

	var defValue = this.m_oES.getIncrementedDisplayText( this.m_listPropDefValue, 
			1, this.m_itemDefValuePostFix );

	var subListName = this.m_oES.addUntitled( this.m_enumPrefix, false, null, defValue );

    if ( subListName )
	{
		this.m_curSubListName = subListName;
		var subList = new PropList( subListName, [], this.m_subListParent.m_propSetSubLists );
		this.m_subListParent.addSubList( subList, "added" );

		// set the default value of the m_fillListPropName to defValue
		var prop = subList.prop( this.m_fillListPropName );
		if ( prop )
			prop.setValue( defValue );

		this.fillFormFromSubList( false );
		var editCtrl = this.getEditCtrl();
		if ( editCtrl )
		{
			editCtrl.focus();
			editCtrl.select();
		}
		this.onSubListChangeNotify( "add", subListName );
	}

}	// createSubList ()

NestedEnumPropListView.prototype.copySubList = function ()
{
	if ( ! this.m_curSubListName )
	{
		/*alert( "Select " + this.m_name + " to copy" );*/
		return ;
	}

	// validate and save the current list's values
	if ( this.m_curSubListName && ( ! this.validateSubList() ) ) 
	{
		return ;
	}
	
	var	defValue = this.m_oES.getIncrementedDisplayText( "Copy", 1, " of " + getCtrlValue( this.getEditCtrl() ) );
	var newSubListName = this.m_oES.addUntitled( this.m_enumPrefix, false, null, defValue );
    if ( newSubListName )
	{

		this.m_subListParent.copySubList( this.m_curSubListName, newSubListName );
		this.m_curSubListName = newSubListName;

		var subList = this.m_subListParent.subList( newSubListName );
		if ( subList )
		{
			// set the default value of the m_fillListPropName to defValue
			var prop = subList.prop( this.m_fillListPropName );
			if ( prop )
				prop.setValue( defValue );
		}

		this.fillFormFromSubList( false );
		var editCtrl = this.getEditCtrl();
		if ( editCtrl )
		{
			editCtrl.focus();
			editCtrl.select();
		}
	}
	this.onSubListChangeNotify( "add", newSubListName );

}	// copySubList ()

NestedEnumPropListView.prototype.incSubList = function ( inc )
{
	// zero or one items in the list? nothing to do
	var listCtrl = this.getListCtrl();
	if ( ! listCtrl ) return ;

	var optCount = listCtrl.options.length;
	if ( optCount < 2 )
		return;

	var selX = listCtrl.selectedIndex ;
	if( selX == -1 )
		return ;

	// only move in increments of one
	if ( !inc )
		return ;
	if (inc > 1)
		inc = 1;
	else if (inc < -1)
		inc = -1;

	var newX = selX + inc ;
	var nMax = optCount - 1 ;
	if ((newX < 0) || (newX > nMax))
		return ;	// can't move any further

	if ( ! this.m_curSubListName )
	{
		this.m_curSubListName = this.m_oES.getItemValue();
	}

	// validate and save the current list's values
	if ( this.m_curSubListName && ( ! this.validateSubList() ) ) 
	{
		return ;
	}

	// save the text of the option we're about to overwrite
	var newSubListName = this.m_oES.getItemValue( newX );

	this.m_subListParent.renameSubList( this.m_curSubListName, "TEMP_LIST_NAME" );
	this.m_subListParent.renameSubList( newSubListName, this.m_curSubListName );
	this.m_subListParent.renameSubList( "TEMP_LIST_NAME", newSubListName );

	// reset the EditSelect combo
	this.m_oES.clear();
	this.m_subListParent.fillSelectList2( listCtrl, this.m_fillListPropName );
	setCtrlValue( listCtrl, newSubListName, true );
	this.m_oES.sync();

	this.m_curSubListName = newSubListName ;

}	// incSubList ()

NestedEnumPropListView.prototype.removeSubList = function ()
{
	if ( ! this.m_curSubListName )
	{
		/*alert( "Select a " + this.m_name + " to delete." );*/
		return;
	}

	var subList = this.getSubList();
	if ( subList )
	{
	    if ( confirm( "Remove " + this.m_itemLabel + " '" + getCtrlValue( this.getEditCtrl() ) + "'?" ) )
		{
			var deletedSubListName = this.m_curSubListName;

			// mark as 'deleted'
			subList.clearForm( this.getForm( deletedSubListName ) );
			this.m_oES.remove();
			if ( subList.m_status == "added" )
			{
				this.m_subListParent.delSubList( subList );
			}
			else
			{
				subList.m_status = "deleted" ;
			}
			this.onSubListChangeNotify( "delete", deletedSubListName );
			this.fillFormFromSubList( false );
		}
	}

}	// removeSubList ()

//</SCRIPT>
