
/*
 * ***** BEGIN LICENSE BLOCK *****  
 * Source last modified: $Id: propview_noedit.js,v 1.2 2003/01/24 02:58:50 bgoldfarb Exp $ 
 *   
 * Portions Copyright (c) 1995-2003 RealNetworks, Inc. All Rights Reserved.  
 *       
 * The contents of this file, and the files included with this file, 
 * are subject to the current version of the RealNetworks Public 
 * Source License (the "RPSL") available at 
 * http://www.helixcommunity.org/content/rpsl unless you have licensed 
 * the file under the current version of the RealNetworks Community 
 * Source License (the "RCSL") available at 
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL 
 * will apply. You may also obtain the license terms directly from 
 * RealNetworks.  You may not use this file except in compliance with 
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable 
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for 
 * the rights, obligations and limitations governing use of the 
 * contents of the file. 
 *   
 * This file is part of the Helix DNA Technology. RealNetworks is the 
 * developer of the Original Code and owns the copyrights in the 
 * portions it created. 
 *   
 * This file, and the files included with this file, is distributed 
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY 
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS 
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES 
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET 
 * ENJOYMENT OR NON-INFRINGEMENT. 
 *  
 * Technology Compatibility Kit Test Suite(s) Location:  
 *    http://www.helixcommunity.org/content/tck  
 *  
 * Contributor(s):  
 *   
 * ***** END LICENSE BLOCK ***** *
*/

//<SCRIPT>

function NestedPropListViewNoEdit ( listName, propList, itemLabel, configRootPath, serverMethod,
	sFormName, sListName, aDirtyImgNames )
{

	if ( ! NestedPropListView.bIsInitialized )
		NestedPropListView.initClass();

	this.base = NestedPropListView ;

	this.m_name = listName;
	this.m_itemLabel = itemLabel ;
	this.m_itemDefValue = itemLabel ;

	this.m_configRootPath = configRootPath;
	this.m_serverMethod = (serverMethod ? serverMethod : "servvar");

	this.m_propList = propList ;
	this.m_subListParent = this.m_propList;

	this.m_submitString = "";
	this.m_oWin = null;
	this.m_oDoc = null;

	this.m_sFormName = sFormName ;
	this.m_sListName = sListName ;
	this.m_aDirtyImgNames = (aDirtyImgNames ? aDirtyImgNames : ["IMG_DIRTY_TAB", "IMG_DIRTY_APPLY"] );

	this.m_parent = null ;

	this.m_resultsTitleListIndex = 3;
	this.m_resultsTitlePropIndex = 4;

	this.m_curSubListName = "";

	this.m_origListChangeHandler = null;
	this.m_origClickHandler = null;
	this.m_origKeyUpHandler = null;

	this.m_bDoDirtyCheck = true ;

	this.m_imgSrcDirty = NestedPropListView.imgSrcDirty;
	this.m_imgSrcClean = NestedPropListView.imgSrcClean;

	this.m_hDirtyCheckTimerID = null;

	this.m_subViews = new Array();

	this.m_bLoaded = false;

}	// NestedPropListViewNoEdit ()
NestedPropListViewNoEdit.prototype = new NestedPropListView ;

NestedPropListViewNoEdit.prototype.getEditCtrl = function ()
{
	return null ;
}

/* 
	before calling this function make sure the propList member has been initialized.
	
	Call this method from your pages onload handler, passing in the
	following page element/obj references:
		oWin		the page's window object, required

	after using the parameters to initialize the object's member properties, onPrelLoad is called. This allows
	subclasses to perform any need initialization. The base class's implementation jsut returns true, if an 
	subclass's onPreLoad returns false the bodyof onLoad is skipped.

	The bodyof this method initializes the form using propList data as well as creating an EditSelect obj
	to tie the list and edit controls together.

	onPostLoad is then called at the end. A do nothing method in the base class onPostLoad should be overridden
	in sub classes to perform custom actions - hide/show/resize elements etc.
*/
NestedPropListViewNoEdit.prototype.onLoad = function ( oWin, fNoInitForm, fNoDisplayData )
{

	// initialize member variables TODO validate parameters	
	if (! oWin ) return;

	if ( ! isXblibInit ) xblibInit();

	this.m_oWin = oWin;
	this.m_oDoc = oWin.document;

	this.m_bLoaded = true ;

	if ( this.preOnLoad() )
	{
		this.m_propList.reset();

		if( this.m_bDoDirtyCheck )
			this.showDirtyFlag( false );

		if ( ! fNoInitForm )
			clearForm( this.getForm() );

		//init any subViews
		for ( var subViewName in this.m_subViews )
		{
			var subView = this.m_subViews[ subViewName ];
			if ( subView )
			{
				subView.onLoad( oWin, true, true );
			}
		}

		if ( ! fNoDisplayData )
		{
			this.initListDataDisplay();
		}

		if ( ! fNoInitForm )
			this.hookForm();

		//because of Mozilla Bug 49980 (as of 4/11/01) we can't use anonymous functions
		//as event handlers - so we assign the instance method call generated by
		// getInstanceEventHandler() to a variable of parent window...
		this.m_oWin._onSelChange = getInstanceEventHandler( this, "onSelChange" );
		//... and then hook it in as the ctrl's change handler
		this.origOnSelChangeHandler = addEvent( this.getListCtrl(), "change", 
			this.m_oWin._onSelChange );
	}
	this.postOnLoad();

}	// onLoad()

NestedPropListViewNoEdit.prototype.onSelChange = function ()
{
	if ( ! this.m_bLoaded ) return ;

	return this.fillFormFromSubList( true );

}	// onESSelChange ()

NestedPropListViewNoEdit.prototype.initListDataDisplay = function ()
{
	this.fillSelectList();
	this.m_propList.fillForm( this.getForm() );
	this.fillFormFromSubList( false );
}

NestedPropListViewNoEdit.prototype.fillFormFromSubList = function ( fValidate )
{
	if ( ! this.m_bLoaded ) return ;

	var listCtrl = this.getListCtrl();
	if ( ! listCtrl ) return ;
	
	var newSubListName = getCtrlValue( listCtrl );
	if ( ! newSubListName ) return ;

	// before filling in the controls with the newly selected sublist's value's
	// validate and store chgs for the current (or old) sublist
	if ( this.m_curSubListName && fValidate && ( ! this.validateSubList() ) )
	{
		return false ;
	}
	
	if ( ! newSubListName ) return false ;

	this.m_curSubListName = newSubListName ;
	var subList = this.getSubList( newSubListName );
	if ( subList )
	{
		subList.fillForm( this.getForm( newSubListName ) );

		//set the propList and fill the select list of any subViews
		for ( var subViewName in this.m_subViews )
		{
			var subView = this.m_subViews[ subViewName ];
			if ( subView && subView.m_bLoaded )
			{
				var subSubList = subList.subList( subViewName );
				if ( subSubList )
				{
					subView.setPropList( subSubList );
					subView.initListDataDisplay();
				} 
			}
		}
	}

	return this.postFillFormFromSubList( fValidate );

}	// fillFormFromSubList ()

NestedPropListViewNoEdit.prototype.validateSubList = function ( subListName )
{
	if ( ! this.m_bLoaded ) return ;

	if ( isBlank( subListName ) )
	{
		subListName = this.m_curSubListName ;
	}

	if ( ! this.preValidateSubList( subListName ) )
	{
		
		return false ;
	}
	var subList = this.m_subListParent.subList( subListName );
	if ( subList )
	{
		var ctrl = subList.validate( this.getForm( subListName ) );
		if ( ctrl ) 
		{
			return rejectInput( ctrl, subList.errMsg );
		}
	}

	//validate any subViews
	for ( var subViewName in this.m_subViews )
	{
		var subView = this.m_subViews[ subViewName ];
		if ( subView && subView.m_bLoaded )
		{
			if ( ! subView.validateSubList() )
				return false ;
		}
	}

	if ( ! this.postValidateSubList( subListName ) )
	{
		
		return false ;
	}

	return true ;

}	// validateSubList ()

// *******  ADD / EDIT / REMOVE / COPY SUBLIST FUNCTIONS ********

NestedPropListViewNoEdit.prototype.onESRename = function ( oldSubListName, newSubListName )
{
	// no renaming allowed
	return false ;

}	// onESRename ()

// called when the select control is empty and the user types into 
// the edit control - create a new sublist with the entered text as the
// sublist name
NestedPropListViewNoEdit.prototype.onESAddNew = function ( oES )
{
	// can't add a list this way

}	// onESAddNew ()

NestedPropListViewNoEdit.prototype.createSubList = function ( subListName )
{
	if ( ! this.m_bLoaded ) return ;

	// validate and save the current list's values
	if ( this.m_curSubListName && ( ! this.validateSubList() ) ) 
	{
		return ;
	}

	var listCtrl = this.getListCtrl();
	if ( ! listCtrl ) return ;

	if ( subListName )
	{
		selAddOption( listCtrl, subListName, subListName, true );
	}
	else
	{
		subListName = selAddGeneric( listCtrl, this.m_itemDefValue, 1, this.m_itemDefValuePostFix );
	}

    if ( subListName )
	{
		this.m_curSubListName = subListName;
		var subList = new PropList( subListName, [], this.m_subListParent.m_propSetSubLists );
		this.m_subListParent.addSubList( subList, "added" );
		subList.clearForm( this.getForm( subListName ) );
		this.fillFormFromSubList( false );
		this.onSubListChangeNotify( "add", subListName );
	}

}	// createSubList ()

NestedPropListViewNoEdit.prototype.copySubList = function ()
{
	if ( ! this.m_bLoaded ) return ;

	if ( ! this.m_curSubListName )
	{
		/*alert( "Select " + this.m_name + " to copy" );*/
		return ;
	}

	// validate and save the current list's values
	if ( this.m_curSubListName && ( ! this.validateSubList() ) ) 
	{
		return ;
	}

	var listCtrl = this.getListCtrl();
	if ( ! listCtrl ) return ;

	var newSubListName = selAddGeneric( listCtrl, "Copy", 1, " of " + this.m_curSubListName );
    if ( newSubListName )
	{
		this.m_subListParent.copySubList( this.m_curSubListName, newSubListName );
		this.m_curSubListName = newSubListName;
		this.fillFormFromSubList( false );
		this.onSubListChangeNotify( "add", newSubListName );
	}

 }	// copySubList ()

NestedPropListViewNoEdit.prototype.removeSubList = function ()
{
	if ( ! this.m_bLoaded ) return ;

	if ( ! this.m_curSubListName )
	{
		
		return;
	}
		
	
	
	var subList = this.getSubList();
	if ( subList )
	{
	    if ( this.confirmRemoveSubList( this.m_curSubListName ) )
		{
			var deletedSubListName = this.m_curSubListName;
			// mark as 'deleted'
			selectDel( this.getListCtrl() );
			subList.clearForm( this.getForm( deletedSubListName ) );
			if ( subList.m_status == "added" )
			{
				this.m_subListParent.delSubList( subList );
			}
			else
			{
				subList.m_status = "deleted" ;
			}
			this.onSubListChangeNotify( "delete", deletedSubListName );
			this.fillFormFromSubList( false );
		}
	}

}	// removeSubList ()

//</SCRIPT>
